/*
 * Decompiled with CFR 0.152.
 */
package net.heartless.heartless_arsonal.entity.custom;

import java.util.List;
import java.util.function.Predicate;
import net.heartless.heartless_arsonal.entity.ModEntities;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3719;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class BloodBathRobotEntity
extends class_1296 {
    private final class_1277 inventory = new class_1277(9);
    private int idleAnimationTimeout = 0;
    private class_2338 patrolCenter;
    private static final int PATROL_RADIUS = 10;
    private static final int CHEST_SEARCH_RADIUS = 6;
    public final class_7094 idleAnimationState = new class_7094();

    public BloodBathRobotEntity(class_1299<? extends class_1296> entityType, class_1937 world) {
        super(entityType, world);
        this.patrolCenter = this.method_24515();
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1366((class_1314)this, 0.5, true));
        this.field_6201.method_6277(6, (class_1352)new class_1391((class_1314)this, 0.5, (Predicate)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_27063}), false));
        this.field_6201.method_6277(7, (class_1352)new SeekChestGoal(this, 0.6));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 4.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1296.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23719, 0.35).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23717, 40.0).method_26868(class_5134.field_23722, 0.5);
    }

    public void method_5773() {
        super.method_5773();
        this.method_5875(false);
        if (this.method_37908().method_8608()) {
            this.setupIdleTimer();
        } else {
            this.pickupNearbyItems();
            this.depositItemsIntoNearbyBarrel();
            this.spawnMovementSmoke();
            this.spawnMovementSmoking();
        }
    }

    private void setupIdleTimer() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private void pickupNearbyItems() {
        List items = this.method_37908().method_8390(class_1542.class, this.method_5829().method_1014(1.5), item -> item.method_5805());
        for (class_1542 itemEntity : items) {
            class_1799 stack = itemEntity.method_6983();
            if (!this.inventory.method_27070(stack)) continue;
            this.inventory.method_5491(stack.method_7972());
            itemEntity.method_31472();
        }
    }

    private void depositItemsIntoNearbyBarrel() {
        class_2338 entityPos = this.method_24515();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int x = -3; x <= 3; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    class_3719 barrel;
                    mutable.method_10103(entityPos.method_10263() + x, entityPos.method_10264() + y, entityPos.method_10260() + z);
                    class_2586 blockEntity = this.method_37908().method_8321((class_2338)mutable);
                    if (!(blockEntity instanceof class_3719)) continue;
                    class_3719 barrelInventory = barrel = (class_3719)blockEntity;
                    boolean deposited = false;
                    for (int i = 0; i < this.inventory.method_5439(); ++i) {
                        class_1799 stack = this.inventory.method_5438(i);
                        if (stack.method_7960()) continue;
                        class_1799 remaining = this.insertStackIntoInventory((class_1263)barrelInventory, stack.method_7972());
                        this.inventory.method_5447(i, remaining);
                        deposited = true;
                    }
                    if (deposited) {
                        barrel.method_5431();
                        this.spawnDepositParticles((class_2338)mutable);
                        this.clearInventory();
                    }
                    return;
                }
            }
        }
    }

    private void clearInventory() {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            this.inventory.method_5447(i, class_1799.field_8037);
        }
    }

    private void spawnDepositParticles(class_2338 pos) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199((class_2394)class_2398.field_11240, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 10, 0.3, 0.3, 0.3, 0.01);
        }
    }

    private void spawnMovementSmoke() {
        double dz;
        double dy;
        double dx;
        if (!this.method_37908().method_8608() && (dx = this.method_18798().field_1352) * dx + (dy = this.method_18798().field_1351) * dy + (dz = this.method_18798().field_1350) * dz > 0.001) {
            ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318() + 0.1, this.method_23321(), 2, 0.1, 0.0, 0.1, 0.01);
        }
    }

    private void spawnMovementSmoking() {
        double dz;
        double dy;
        double dx;
        if (!this.method_37908().method_8608() && (dx = this.method_18798().field_1352) * dx + (dy = this.method_18798().field_1351) * dy + (dz = this.method_18798().field_1350) * dz > 0.001) {
            ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_17430, this.method_23317(), this.method_23318() + 0.1, this.method_23321(), 2, 0.1, 0.0, 0.1, 0.01);
        }
    }

    private void openChestVisual(class_2338 pos) {
        class_2680 state = this.method_37908().method_8320(pos);
        if (!this.method_37908().method_8608()) {
            this.method_37908().method_8427(pos, state.method_26204(), 1, 1);
        }
    }

    private void closeChestVisual(class_2338 pos) {
        class_2680 state = this.method_37908().method_8320(pos);
        if (!this.method_37908().method_8608()) {
            this.method_37908().method_8427(pos, state.method_26204(), 1, 0);
        }
    }

    private class_1799 insertStackIntoInventory(class_1263 inventory, class_1799 stack) {
        for (int slot = 0; slot < inventory.method_5439(); ++slot) {
            int transferAmount;
            class_1799 existing = inventory.method_5438(slot);
            if (!inventory.method_5437(slot, stack)) continue;
            if (existing.method_7960()) {
                inventory.method_5447(slot, stack);
                return class_1799.field_8037;
            }
            if (!this.canMerge(existing, stack) || (transferAmount = Math.min(stack.method_7947(), existing.method_7914() - existing.method_7947())) <= 0) continue;
            existing.method_7933(transferAmount);
            stack.method_7934(transferAmount);
            if (!stack.method_7960()) continue;
            return class_1799.field_8037;
        }
        return stack;
    }

    private boolean canMerge(class_1799 stack1, class_1799 stack2) {
        return stack1.method_7909() == stack2.method_7909() && stack1.method_7919() == stack2.method_7919() && class_1799.method_7973((class_1799)stack1, (class_1799)stack2);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntities.BLOOD_BATH_ROBOT.method_5883((class_1937)world);
    }

    public class_2338 getPatrolCenter() {
        return this.patrolCenter;
    }

    public void setPatrolCenter(class_2338 center) {
        this.patrolCenter = center;
    }

    public static class SeekChestGoal
    extends class_1352 {
        private final BloodBathRobotEntity robot;
        private final double speed;
        private class_2338 targetBarrel;

        public SeekChestGoal(BloodBathRobotEntity robot, double speed) {
            this.robot = robot;
            this.speed = speed;
        }

        public boolean method_6264() {
            return this.robotHasItems() && this.findNearestChest();
        }

        public void method_6269() {
            if (this.targetBarrel != null) {
                this.robot.method_5942().method_6337((double)this.targetBarrel.method_10263() + 0.5, (double)this.targetBarrel.method_10264() + 0.5, (double)this.targetBarrel.method_10260() + 0.5, this.speed);
            }
        }

        private boolean robotHasItems() {
            for (int i = 0; i < this.robot.inventory.method_5439(); ++i) {
                if (this.robot.inventory.method_5438(i).method_7960()) continue;
                return true;
            }
            return false;
        }

        private boolean findNearestChest() {
            class_2338 robotPos = this.robot.method_24515();
            double closestDistance = Double.MAX_VALUE;
            class_2338 closestChest = null;
            for (class_2338 pos : class_2338.method_29715((class_238)new class_238(robotPos).method_1014(6.0)).map(class_2338::method_10062).toList()) {
                double distance;
                class_2586 be = this.robot.method_37908().method_8321(pos);
                if (!(be instanceof class_2595) || !((distance = robotPos.method_10262((class_2382)pos)) < closestDistance)) continue;
                closestDistance = distance;
                closestChest = pos;
            }
            if (closestChest != null) {
                this.targetBarrel = closestChest;
                return true;
            }
            return false;
        }
    }

    public static class PatrolAreaGoal
    extends class_1352 {
        private final class_1314 entity;
        private final double speed;
        private int cooldown = 0;

        public PatrolAreaGoal(class_1314 entity, double speed) {
            this.entity = entity;
            this.speed = speed;
        }

        public boolean method_6264() {
            return this.cooldown-- <= 0;
        }

        public void method_6269() {
            class_1314 class_13142 = this.entity;
            if (class_13142 instanceof BloodBathRobotEntity) {
                BloodBathRobotEntity robot = (BloodBathRobotEntity)class_13142;
                class_2338 center = robot.getPatrolCenter();
                class_5819 random = this.entity.method_59922();
                int dx = random.method_43048(20) - 10;
                int dz = random.method_43048(20) - 10;
                class_2338 target = center.method_10069(dx, 0, dz);
                this.entity.method_5942().method_6337((double)target.method_10263(), (double)target.method_10264(), (double)target.method_10260(), this.speed);
                this.cooldown = 100 + random.method_43048(100);
            }
        }
    }
}

