/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data.client;

import com.ninni.dye_depot.data.ModCompat;
import com.ninni.dye_depot.registry.DDBlocks;
import com.ninni.dye_depot.registry.DDItems;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import io.github.fabricators_of_create.porting_lib.models.generators.item.ItemModelBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.item.ItemModelProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class DDItemModels
extends ItemModelProvider {
    private final CompletableFuture<HolderLookup.Provider> lookup;

    public DDItemModels(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup, ExistingFileHelper fileHelper) {
        super(output, "dye_depot", fileHelper);
        this.lookup = lookup;
    }

    protected void registerModels() {
        HolderLookup.Provider lookup = this.lookup.join();
        HolderLookup.RegistryLookup itemLookup = lookup.lookupOrThrow(Registries.ITEM);
        DDItems.DYES.holders().forEach(this::basicItem);
        DDBlocks.WOOL.holders().forEach(this::blockReference);
        DDBlocks.CARPETS.holders().forEach(this::blockReference);
        DDBlocks.TERRACOTTA.holders().forEach(this::blockReference);
        DDBlocks.CONCRETE.holders().forEach(this::blockReference);
        DDBlocks.CONCRETE_POWDER.holders().forEach(this::blockReference);
        DDBlocks.GLAZED_TERRACOTTA.holders().forEach(this::blockReference);
        DDBlocks.STAINED_GLASS.holders().forEach(this::blockReference);
        DDBlocks.STAINED_GLASS_PANES.forEach(this::glassPane);
        DDBlocks.SHULKER_BOXES.holders().forEach(this::shulkerBox);
        DDBlocks.CANDLES.holders().forEach(this::basicItem);
        DDBlocks.BANNERS.holders().forEach(this::banner);
        DDBlocks.BEDS.forEach(this::bed);
        DDBlocks.DYE_BASKETS.holders().forEach(this::blockReference);
        ModCompat.supplementariesHolders(itemLookup, "flag").holders().forEach(this::flag);
        ModCompat.supplementariesHolders(itemLookup, "present").forEach(this::present);
        ModCompat.supplementariesHolders(itemLookup, "trapped_present").forEach(this::present);
        ModCompat.supplementariesHolders(itemLookup, "candle_holder").forEach(this::candleHolder);
        ModCompat.supplementariesSquaredHolders(itemLookup, "gold_candle_holder").forEach(this::candleHolder);
    }

    private void basicItem(Holder<? extends ItemLike> item) {
        this.basicItem(((ItemLike)item.value()).asItem());
    }

    private void basicItem(Holder<? extends ItemLike> item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.key(item).toString(), this.vanillaResource("generated"))).texture("layer0", texture);
    }

    private void glassPane(DyeColor color, Holder<? extends ItemLike> item) {
        this.basicItem(item, this.blockTexture(DDBlocks.STAINED_GLASS.holderOrThrow(color)));
    }

    private ResourceLocation blockTexture(Holder<? extends Block> block) {
        return ((ResourceKey)block.unwrapKey().orElseThrow()).location().withPrefix("block/");
    }

    private void blockReference(Holder<? extends Block> block) {
        this.withExistingParent(this.name(block), this.blockTexture(block));
    }

    private void shulkerBox(Holder<? extends Block> block) {
        ((ItemModelBuilder)this.withExistingParent(this.name(block), this.vanillaResource("template_shulker_box"))).texture("particle", this.blockTexture(block));
    }

    private void banner(Holder<? extends ItemLike> item) {
        this.withExistingParent(this.name(item), this.vanillaResource("template_banner"));
    }

    private void bed(DyeColor color, Holder<? extends ItemLike> item) {
        ((ItemModelBuilder)this.withExistingParent(this.name(item), this.vanillaResource("template_bed"))).texture("particle", this.blockTexture(DDBlocks.WOOL.holderOrThrow(color)));
    }

    private void candleHolder(DyeColor color, Holder<? extends ItemLike> item) {
        String namespace = this.key(item).getNamespace();
        this.basicItem(item, new ResourceLocation(namespace, "item/candle_holders/" + String.valueOf(color)));
    }

    private void flag(Holder<? extends ItemLike> item) {
        this.withExistingParent(this.key(item).toString(), new ResourceLocation("supplementaries", "item/flag_black"));
    }

    private void present(DyeColor color, Holder<? extends ItemLike> item) {
        String type = this.name(item).replace("_" + String.valueOf(color), "");
        this.withExistingParent(this.key(item).toString(), new ResourceLocation("supplementaries", "block/" + type + "s/" + String.valueOf(color) + "_closed"));
    }

    private ResourceLocation vanillaResource(String name) {
        return new ResourceLocation("item/" + name);
    }

    private String name(Holder<? extends ItemLike> item) {
        return this.key(item).getPath();
    }

    private ResourceLocation key(Holder<? extends ItemLike> item) {
        return ((ResourceKey)item.unwrapKey().orElseThrow()).location();
    }
}

