/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data.server;

import com.ninni.dye_depot.data.ModCompat;
import com.ninni.dye_depot.registry.DDBlocks;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;

public class DDBlockLoot
extends FabricBlockLootTableProvider {
    private final CompletableFuture<HolderLookup.Provider> lookup;

    public DDBlockLoot(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> lookup) {
        super(output);
        this.lookup = lookup;
    }

    public void generate() {
        HolderLookup.Provider lookup = this.lookup.join();
        HolderLookup.RegistryLookup blockLookup = lookup.lookupOrThrow(Registries.BLOCK);
        DDBlocks.BANNERS.values().forEach(this::dropBanner);
        DDBlocks.BEDS.values().forEach(this::dropBed);
        DDBlocks.CANDLES.values().forEach(this::dropCandle);
        DDBlocks.CANDLE_CAKES.values().forEach(this::dropCandleCake);
        DDBlocks.CARPETS.values().forEach(arg_0 -> ((DDBlockLoot)this).dropSelf(arg_0));
        DDBlocks.CONCRETE.values().forEach(arg_0 -> ((DDBlockLoot)this).dropSelf(arg_0));
        DDBlocks.CONCRETE_POWDER.values().forEach(arg_0 -> ((DDBlockLoot)this).dropSelf(arg_0));
        DDBlocks.DYE_BASKETS.values().forEach(arg_0 -> ((DDBlockLoot)this).dropSelf(arg_0));
        DDBlocks.GLAZED_TERRACOTTA.values().forEach(arg_0 -> ((DDBlockLoot)this).dropSelf(arg_0));
        DDBlocks.SHULKER_BOXES.values().forEach(this::dropShulkerBox);
        DDBlocks.STAINED_GLASS.values().forEach(arg_0 -> ((DDBlockLoot)this).dropWhenSilkTouch(arg_0));
        DDBlocks.STAINED_GLASS_PANES.values().forEach(arg_0 -> ((DDBlockLoot)this).dropWhenSilkTouch(arg_0));
        DDBlocks.TERRACOTTA.values().forEach(arg_0 -> ((DDBlockLoot)this).dropSelf(arg_0));
        DDBlocks.WOOL.values().forEach(arg_0 -> ((DDBlockLoot)this).dropSelf(arg_0));
        BlockLootSubProvider supplementariesLoot = this.withConditions(new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{"supplementaries"})});
        ModCompat.supplementariesHolders(blockLookup, "flag").values().forEach(it -> supplementariesLoot.add(it, this.createFlagDrops((Block)it)));
        ModCompat.supplementariesHolders(blockLookup, "candle_holder").values().forEach(it -> supplementariesLoot.add(it, this.createCandleDrops((Block)it)));
        ModCompat.supplementariesSquaredHolders(blockLookup, "gold_candle_holder").values().forEach(it -> supplementariesLoot.add(it, this.createCandleDrops((Block)it)));
    }

    private void dropBanner(Block block) {
        this.add(block, this.createBannerDrop(block));
    }

    private void dropBed(Block block) {
        this.add(block, this.createSinglePropConditionTable(block, (Property)BedBlock.PART, (Comparable)BedPart.HEAD));
    }

    private void dropCandle(Block block) {
        this.add(block, this.createCandleDrops(block));
    }

    private void dropCandleCake(Block block) {
        this.add(block, DDBlockLoot.createCandleCakeDrops((Block)block));
    }

    private void dropShulkerBox(Block block) {
        this.add(block, this.createShulkerBoxDrop(block));
    }

    private LootTable.Builder createTable(Block block, LootPoolEntryContainer.Builder<?> entry) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootPool.lootPool().add(entry)));
    }

    private LootTable.Builder createFlagDrops(Block block) {
        LootPoolSingletonContainer.Builder entry = LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("Patterns", "BlockEntityTag.Patterns"));
        return this.createTable(block, (LootPoolEntryContainer.Builder<?>)entry);
    }
}

