/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.registry;

import com.google.common.collect.ImmutableMap;
import com.ninni.dye_depot.DyeDepot;
import com.ninni.dye_depot.block.DDBannerBlock;
import com.ninni.dye_depot.block.DDBedBlock;
import com.ninni.dye_depot.block.DDShulkerBoxBlock;
import com.ninni.dye_depot.block.DDWallBannerBlock;
import com.ninni.dye_depot.block.DyeBasketBlock;
import com.ninni.dye_depot.registry.DDDyes;
import com.ninni.dye_depot.registry.DyedHolders;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class DDBlocks {
    public static final DyedHolders<Block, Block> WOOL = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_wool", () -> new Block(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.WHITE_WOOL).mapColor(dye))));
    public static final DyedHolders<Block, Block> CARPETS = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_carpet", () -> new WoolCarpetBlock(dye, BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.WHITE_CARPET).mapColor(dye))));
    public static final DyedHolders<Block, Block> TERRACOTTA = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_terracotta", () -> new Block(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.WHITE_TERRACOTTA).mapColor(dye))));
    private static final Map<DyeColor, MapColor> CONCRETE_COLORS = new ImmutableMap.Builder().put((Object)DDDyes.MAROON.get(), (Object)MapColor.CRIMSON_HYPHAE).put((Object)DDDyes.ROSE.get(), (Object)MapColor.COLOR_RED).put((Object)DDDyes.CORAL.get(), (Object)MapColor.PODZOL).put((Object)DDDyes.INDIGO.get(), (Object)MapColor.WARPED_HYPHAE).put((Object)DDDyes.NAVY.get(), (Object)MapColor.TERRACOTTA_BLACK).put((Object)DDDyes.SLATE.get(), (Object)MapColor.COLOR_GRAY).put((Object)DDDyes.OLIVE.get(), (Object)MapColor.COLOR_BROWN).put((Object)DDDyes.AMBER.get(), (Object)MapColor.WOOD).put((Object)DDDyes.BEIGE.get(), (Object)MapColor.TERRACOTTA_WHITE).put((Object)DDDyes.TEAL.get(), (Object)MapColor.COLOR_GRAY).put((Object)DDDyes.MINT.get(), (Object)MapColor.DEEPSLATE).put((Object)DDDyes.AQUA.get(), (Object)MapColor.WARPED_WART_BLOCK).put((Object)DDDyes.VERDANT.get(), (Object)MapColor.TERRACOTTA_BLACK).put((Object)DDDyes.FOREST.get(), (Object)MapColor.COLOR_GREEN).put((Object)DDDyes.GINGER.get(), (Object)MapColor.NETHER).put((Object)DDDyes.TAN.get(), (Object)MapColor.DIRT).build();
    public static final DyedHolders<Block, Block> CONCRETE = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_concrete", () -> new Block(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.WHITE_CONCRETE).mapColor(CONCRETE_COLORS.get(dye)))));
    public static final DyedHolders<Block, Block> CONCRETE_POWDER = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_concrete_powder", () -> new ConcretePowderBlock(CONCRETE.getOrThrow((DyeColor)dye), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.WHITE_CONCRETE_POWDER).mapColor(dye))));
    public static final DyedHolders<Block, Block> GLAZED_TERRACOTTA = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_glazed_terracotta", () -> new GlazedTerracottaBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.WHITE_GLAZED_TERRACOTTA).mapColor(dye))));
    public static final DyedHolders<Block, Block> STAINED_GLASS = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_stained_glass", () -> new StainedGlassBlock(dye, BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.WHITE_STAINED_GLASS))));
    public static final DyedHolders<StainedGlassPaneBlock, Block> STAINED_GLASS_PANES = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_stained_glass_pane", () -> new StainedGlassPaneBlock(dye, BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.WHITE_STAINED_GLASS_PANE))));
    public static final DyedHolders<Block, Block> SHULKER_BOXES = DyedHolders.createModded(dye -> DDBlocks.register(String.valueOf(dye) + "_shulker_box", () -> DDBlocks.shulkerBox(dye, BlockBehaviour.Properties.of().mapColor(dye))));
    public static final DyedHolders<Block, Block> CANDLES = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_candle", () -> new CandleBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.WHITE_CANDLE).mapColor(dye))));
    public static final DyedHolders<Block, Block> CANDLE_CAKES = DyedHolders.createModded(dye -> DDBlocks.register(String.valueOf(dye) + "_candle_cake", () -> new CandleCakeBlock(CANDLES.getOrThrow((DyeColor)dye), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.WHITE_CANDLE_CAKE))));
    public static final DyedHolders<Block, Block> BANNERS = DyedHolders.createModded(dye -> DDBlocks.register(String.valueOf(dye) + "_banner", () -> DDBlocks.banner(dye)));
    public static final DyedHolders<Block, Block> WALL_BANNERS = DyedHolders.createModded(dye -> DDBlocks.register(String.valueOf(dye) + "_wall_banner", () -> DDBlocks.wallBanner(dye)));
    public static final DyedHolders<Block, Block> BEDS = DyedHolders.createModded(dye -> DDBlocks.register(String.valueOf(dye) + "_bed", () -> DDBlocks.bed(dye)));
    public static final DyedHolders<Block, Block> DYE_BASKETS = DyedHolders.createWithVanilla(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_dye_basket", () -> new DyeBasketBlock((DyeColor)dye, BlockBehaviour.Properties.of().strength(0.8f).sound(SoundType.WOOL).ignitedByLava().mapColor(dye))));

    private static BannerBlock banner(DyeColor dye) {
        return new DDBannerBlock(dye, BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.WHITE_BANNER));
    }

    private static WallBannerBlock wallBanner(DyeColor dye) {
        return new DDWallBannerBlock(dye, BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.WHITE_WALL_BANNER).dropsLike(BANNERS.getOrThrow(dye)));
    }

    private static BedBlock bed(DyeColor color) {
        return new DDBedBlock(color, BlockBehaviour.Properties.of().mapColor(state -> state.getValue((Property)BedBlock.PART) == BedPart.FOOT ? color.getMapColor() : MapColor.WOOL).sound(SoundType.WOOD).strength(0.2f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    }

    private static ShulkerBoxBlock shulkerBox(DyeColor color, BlockBehaviour.Properties properties) {
        BlockBehaviour.StatePredicate statePredicate = (blockState, blockGetter, blockPos) -> {
            BlockEntity blockEntity = blockGetter.getBlockEntity(blockPos);
            if (blockEntity instanceof ShulkerBoxBlockEntity) {
                ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)blockEntity;
                return shulkerBoxBlockEntity.isClosed();
            }
            return true;
        };
        return new DDShulkerBoxBlock(color, properties.forceSolidOn().strength(2.0f).dynamicShape().noOcclusion().isSuffocating(statePredicate).isViewBlocking(statePredicate).pushReaction(PushReaction.DESTROY).isRedstoneConductor(Blocks::always));
    }

    private static <T extends Block> Holder<T> register(String id, Supplier<T> block) {
        return Registry.registerForHolder((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)DyeDepot.modLoc(id), (Object)((Block)block.get()));
    }

    private static <T extends Block> Holder<T> registerWithItem(String id, Supplier<T> block) {
        Holder<T> supplier = DDBlocks.register(id, block);
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)DyeDepot.modLoc(id), (Object)new BlockItem((Block)supplier.value(), new Item.Properties()));
        return supplier;
    }
}

