/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data.server;

import com.ninni.dye_depot.data.ModCompat;
import com.ninni.dye_depot.registry.DDBlocks;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;

public class DDBlockLoot
extends BlockLootSubProvider {
    private final Collection<Block> knownBlocks = new HashSet<Block>();

    public DDBlockLoot(HolderLookup.Provider lookup) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookup);
    }

    public void generate() {
        HolderLookup.RegistryLookup blockLookup = this.registries.lookupOrThrow(Registries.BLOCK);
        DDBlocks.BANNERS.values().forEach(this::dropBanner);
        DDBlocks.BEDS.values().forEach(this::dropBed);
        DDBlocks.CANDLES.values().forEach(this::dropCandle);
        DDBlocks.CANDLE_CAKES.values().forEach(this::dropCandleCake);
        DDBlocks.CARPETS.values().forEach(x$0 -> this.dropSelf((Block)x$0));
        DDBlocks.CONCRETE.values().forEach(x$0 -> this.dropSelf((Block)x$0));
        DDBlocks.CONCRETE_POWDER.values().forEach(x$0 -> this.dropSelf((Block)x$0));
        DDBlocks.DYE_BASKETS.values().forEach(x$0 -> this.dropSelf((Block)x$0));
        DDBlocks.GLAZED_TERRACOTTA.values().forEach(x$0 -> this.dropSelf((Block)x$0));
        DDBlocks.SHULKER_BOXES.values().forEach(this::dropShulkerBox);
        DDBlocks.STAINED_GLASS.values().forEach(x$0 -> this.dropWhenSilkTouch((Block)x$0));
        DDBlocks.STAINED_GLASS_PANES.values().forEach(x$0 -> this.dropWhenSilkTouch((Block)x$0));
        DDBlocks.TERRACOTTA.values().forEach(x$0 -> this.dropSelf((Block)x$0));
        DDBlocks.WOOL.values().forEach(x$0 -> this.dropSelf((Block)x$0));
        DDBlockLoot supplementariesLoot = this;
        ModCompat.supplementariesHolders(blockLookup, "flag").values().forEach(it -> supplementariesLoot.add((Block)it, this.createFlagDrops((Block)it)));
        ModCompat.supplementariesHolders(blockLookup, "candle_holder").values().forEach(it -> supplementariesLoot.add((Block)it, this.createCandleDrops((Block)it)));
        ModCompat.supplementariesSquaredHolders(blockLookup, "gold_candle_holder").values().forEach(it -> supplementariesLoot.add((Block)it, this.createCandleDrops((Block)it)));
    }

    private void dropBanner(Block block) {
        this.add(block, this.createBannerDrop(block));
    }

    private void dropBed(Block block) {
        this.add(block, this.createSinglePropConditionTable(block, (Property)BedBlock.PART, (Comparable)BedPart.HEAD));
    }

    private void dropCandle(Block block) {
        this.add(block, this.createCandleDrops(block));
    }

    private void dropCandleCake(Block block) {
        this.add(block, DDBlockLoot.createCandleCakeDrops((Block)block));
    }

    private void dropShulkerBox(Block block) {
        this.add(block, this.createShulkerBoxDrop(block));
    }

    private LootTable.Builder createTable(Block block, LootPoolEntryContainer.Builder<?> entry) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootPool.lootPool().add(entry)));
    }

    private LootTable.Builder createFlagDrops(Block block) {
        LootPoolSingletonContainer.Builder entry = LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.CUSTOM_NAME).include(DataComponents.ITEM_NAME).include(DataComponents.HIDE_ADDITIONAL_TOOLTIP).include(DataComponents.BANNER_PATTERNS));
        return this.createTable(block, (LootPoolEntryContainer.Builder<?>)entry);
    }

    protected void add(Block block, LootTable.Builder builder) {
        super.add(block, builder);
        this.knownBlocks.add(block);
    }

    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }
}

