/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data.server;

import com.ninni.dye_depot.DyeDepot;
import com.ninni.dye_depot.data.ModCompat;
import com.ninni.dye_depot.registry.DDBlocks;
import com.ninni.dye_depot.registry.DDDyes;
import com.ninni.dye_depot.registry.DDItems;
import com.ninni.dye_depot.registry.DDTags;
import com.ninni.dye_depot.registry.DyedHolders;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.FalseCondition;
import net.neoforged.neoforge.common.conditions.ICondition;

public class DDRecipes
extends RecipeProvider {
    private final DyedHolders<Item, Item> dyes;
    private final HolderLookup.RegistryLookup<Block> blockLookup;
    private final HolderLookup.RegistryLookup<Item> itemLookup;

    public DDRecipes(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupFuture) {
        super(output, lookupFuture);
        HolderLookup.Provider lookup = lookupFuture.join();
        this.dyes = DDItems.DYES.mergeVanilla((HolderLookup.RegistryLookup<Item>)lookup.lookupOrThrow(Registries.ITEM));
        this.blockLookup = lookup.lookupOrThrow(Registries.BLOCK);
        this.itemLookup = lookup.lookupOrThrow(Registries.ITEM);
    }

    public void buildRecipes(RecipeOutput output) {
        String namespace = "dye_depot:";
        DDBlocks.BANNERS.forEach((dye, block) -> DDRecipes.banner((RecipeOutput)output, (ItemLike)((ItemLike)block.value()), (ItemLike)((ItemLike)DDBlocks.WOOL.getOrThrow((DyeColor)dye))));
        this.dyeing(output, RecipeCategory.DECORATIONS, DDBlocks.BEDS.mergeVanilla(this.blockLookup), (TagKey<Item>)ItemTags.BEDS);
        DDBlocks.BEDS.forEach((dye, block) -> DDRecipes.bedFromPlanksAndWool((RecipeOutput)output, (ItemLike)((ItemLike)block.value()), (ItemLike)((ItemLike)DDBlocks.WOOL.getOrThrow((DyeColor)dye))));
        DDBlocks.CANDLES.forEach((dye, block) -> DDRecipes.candle((RecipeOutput)output, (ItemLike)((ItemLike)block.value()), (ItemLike)((ItemLike)this.dyes.getOrThrow((DyeColor)dye))));
        this.dyeing(output, RecipeCategory.DECORATIONS, DDBlocks.CARPETS.mergeVanilla(this.blockLookup), (TagKey<Item>)ItemTags.WOOL_CARPETS);
        DDBlocks.CARPETS.forEach((dye, block) -> DDRecipes.carpet((RecipeOutput)output, (ItemLike)((ItemLike)block.value()), (ItemLike)((ItemLike)DDBlocks.WOOL.getOrThrow((DyeColor)dye))));
        DDBlocks.CONCRETE_POWDER.forEach((dye, block) -> DDRecipes.concretePowder((RecipeOutput)output, (ItemLike)((ItemLike)block.value()), (ItemLike)((ItemLike)this.dyes.getOrThrow((DyeColor)dye))));
        DDBlocks.GLAZED_TERRACOTTA.forEach((dye, block) -> DDRecipes.smeltingResultFromBase((RecipeOutput)output, (ItemLike)((ItemLike)block.value()), (ItemLike)((ItemLike)DDBlocks.TERRACOTTA.getOrThrow((DyeColor)dye))));
        DDBlocks.STAINED_GLASS.forEach((dye, block) -> DDRecipes.stainedGlassFromGlassAndDye((RecipeOutput)output, (ItemLike)((ItemLike)block.value()), (ItemLike)((ItemLike)this.dyes.getOrThrow((DyeColor)dye))));
        DDBlocks.STAINED_GLASS_PANES.forEach((dye, block) -> {
            Item dyeItem = this.dyes.getOrThrow((DyeColor)dye);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)block.value()), (int)8).define(Character.valueOf('#'), (ItemLike)Blocks.GLASS_PANE).define(Character.valueOf('$'), (ItemLike)dyeItem).pattern("###").pattern("#$#").pattern("###").group("stained_glass_pane").unlockedBy("has_glass_pane", DDRecipes.has((ItemLike)Blocks.GLASS_PANE)).unlockedBy(DDRecipes.getHasName((ItemLike)dyeItem), DDRecipes.has((ItemLike)dyeItem)).save(output, namespace + DDRecipes.getConversionRecipeName((ItemLike)((ItemLike)block.value()), (ItemLike)Blocks.GLASS_PANE));
            DDRecipes.stainedGlassPaneFromStainedGlass((RecipeOutput)output, (ItemLike)((ItemLike)block.value()), (ItemLike)((ItemLike)DDBlocks.STAINED_GLASS.getOrThrow((DyeColor)dye)));
        });
        DDBlocks.TERRACOTTA.forEach((dye, block) -> DDRecipes.coloredTerracottaFromTerracottaAndDye((RecipeOutput)output, (ItemLike)((ItemLike)block.value()), (ItemLike)((ItemLike)this.dyes.getOrThrow((DyeColor)dye))));
        DDBlocks.DYE_BASKETS.forEach((dye, block) -> DDRecipes.nineBlockStorageRecipes((RecipeOutput)output, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.dyes.getOrThrow((DyeColor)dye)), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)block.value()), (String)(namespace + DDRecipes.getItemName((ItemLike)((ItemLike)block.value()))), null, (String)(namespace + String.valueOf(dye) + "_dye_from_basket"), (String)(String.valueOf(dye) + "_dye")));
        this.dyeing(output, RecipeCategory.MISC, DDBlocks.WOOL, (TagKey<Item>)ItemTags.WOOL);
        this.dyeConversion(output, DDDyes.AMBER.get(), (ItemLike)Items.GLOW_BERRIES, 1);
        this.dyeConversion(output, DDDyes.AMBER.get(), (ItemLike)Items.HONEYCOMB, 2);
        this.dyeConversion(output, DDDyes.AQUA.get(), (ItemLike)Items.GLOW_INK_SAC, 1);
        this.dyeConversion(output, DDDyes.BEIGE.get(), (ItemLike)Items.OXEYE_DAISY, 1);
        this.dyeConversion(output, DDDyes.CORAL.get(), (ItemLike)Items.NAUTILUS_SHELL, 2);
        this.dyeSmelting(output, DDDyes.CORAL.get(), DDTags.SMELTS_INTO_CORAL_DYE);
        this.dyeConversion(output, DDDyes.FOREST.get(), (ItemLike)Items.BAMBOO, 1);
        this.dyeSmelting(output, DDDyes.GINGER.get(), (ItemLike)Items.PUMPKIN);
        this.dyeConversion(output, DDDyes.MAROON.get(), (ItemLike)Items.SPIDER_EYE, 1);
        this.dyeConversion(output, DDDyes.OLIVE.get(), (ItemLike)Items.POISONOUS_POTATO, 1);
        this.dyeConversion(output, DDDyes.TAN.get(), (ItemLike)Items.GLOWSTONE_DUST, 1);
        this.dyeConversion(output, DDDyes.VERDANT.get(), (ItemLike)Items.DRIED_KELP, 1);
        this.dyeSmelting(output, DDDyes.VERDANT.get(), (ItemLike)Items.VINE);
        this.dyeConversion(output, DDDyes.ROSE.get(), (ItemLike)Items.ROSE_BUSH, 2);
        this.dyeSmelting(output, DDDyes.TEAL.get(), (ItemLike)Items.PRISMARINE_SHARD);
        this.dyeMixing(output, DyeColor.BLACK, DyeColor.GRAY, DyeColor.BLACK);
        this.dyeMixing(output, DyeColor.BLACK, DyeColor.LIGHT_GRAY, DyeColor.BLACK, DyeColor.BLACK);
        this.dyeMixing(output, DyeColor.BLACK, DyeColor.WHITE, DyeColor.BLACK, DyeColor.BLACK, DyeColor.BLACK);
        this.dyeMixing(output, DyeColor.GRAY, DyeColor.LIGHT_GRAY, DyeColor.BLACK);
        this.dyeMixing(output, DyeColor.GRAY, DyeColor.WHITE, DyeColor.BLACK, DyeColor.BLACK);
        this.dyeMixing(output, DyeColor.WHITE, DyeColor.BLACK, DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE);
        this.dyeMixing(output, DyeColor.WHITE, DyeColor.GRAY, DyeColor.WHITE, DyeColor.WHITE);
        this.dyeMixing(output, DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.WHITE);
        this.dyeColorSpectrum(output, DDDyes.CORAL.get(), DyeColor.RED, DyeColor.PURPLE, DDDyes.ROSE.get(), DDDyes.MAROON.get());
        this.dyeColorSpectrum(output, DDDyes.AQUA.get(), DyeColor.CYAN, DyeColor.GREEN, DDDyes.MINT.get(), DDDyes.TEAL.get());
        this.dyeColorSpectrum(output, DyeColor.LIME, DyeColor.GREEN, DyeColor.YELLOW, DDDyes.FOREST.get(), DDDyes.VERDANT.get());
        this.dyeColorSpectrum(output, DyeColor.PINK, DyeColor.MAGENTA, DyeColor.BLUE, DyeColor.PURPLE, DDDyes.INDIGO.get());
        this.dyeColorSpectrum(output, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.CYAN, DDDyes.SLATE.get(), DDDyes.NAVY.get());
        this.dyeColorSpectrum(output, DDDyes.TAN.get(), DyeColor.ORANGE, DyeColor.RED, DDDyes.GINGER.get(), DyeColor.BROWN);
        this.dyeColorSpectrum(output, DDDyes.BEIGE.get(), DyeColor.YELLOW, DyeColor.ORANGE, DDDyes.AMBER.get(), DDDyes.OLIVE.get());
        this.dyeMixing(output, DyeColor.GREEN, DyeColor.BLUE, DyeColor.YELLOW);
        this.dyeMixing(output, DyeColor.MAGENTA, DDDyes.INDIGO.get(), DyeColor.LIGHT_BLUE);
        this.disable(output, ResourceLocation.withDefaultNamespace((String)"gray_dye"));
        this.disable(output, ResourceLocation.withDefaultNamespace((String)"light_gray_dye_from_oxeye_daisy"));
        this.disable(output, ResourceLocation.withDefaultNamespace((String)"magenta_dye_from_blue_red_pink"));
        this.disable(output, ResourceLocation.withDefaultNamespace((String)"magenta_dye_from_blue_red_white_dye"));
        this.disable(output, ResourceLocation.withDefaultNamespace((String)"magenta_dye_from_purple_and_pink"));
        this.disable(output, ResourceLocation.withDefaultNamespace((String)"pink_dye_from_red_white_dye"));
        this.disable(output, ResourceLocation.withDefaultNamespace((String)"purple_dye"));
        this.disable(output, ResourceLocation.withDefaultNamespace((String)"red_dye_from_rose_bush"));
        ModCompat.supplementariesHolders(this.itemLookup, "candle_holder").forEach((dye, block) -> {
            Block candle = DDBlocks.CANDLES.getOrThrow((DyeColor)dye);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)block.value())).pattern("NCN").pattern(" N ").define(Character.valueOf('C'), (ItemLike)candle).define(Character.valueOf('N'), (ItemLike)Items.IRON_INGOT).group("candle_holder").unlockedBy("has_candle", DDRecipes.has((ItemLike)candle)).save(DDRecipes.withConditions(output, ModCompat.supplementariesFlag("candle_holder")));
        });
        ModCompat.supplementariesSquaredHolders(this.itemLookup, "gold_candle_holder").forEach((dye, block) -> {
            Block candle = DDBlocks.CANDLES.getOrThrow((DyeColor)dye);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)block.value())).pattern("C").pattern("N").define(Character.valueOf('C'), (ItemLike)candle).define(Character.valueOf('N'), (ItemLike)Items.GOLD_INGOT).group("gold_candle_holder").unlockedBy("has_candle", DDRecipes.has((ItemLike)candle)).save(DDRecipes.withConditions(output, ModCompat.supplementariesFlag("candle_holder")));
        });
        ModCompat.supplementariesHolders(this.itemLookup, "flag").forEach((dye, block) -> {
            Block wool = DDBlocks.WOOL.getOrThrow((DyeColor)dye);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)block.value())).pattern("###").pattern("###").pattern("|  ").define(Character.valueOf('#'), (ItemLike)wool).define(Character.valueOf('|'), (ItemLike)Items.STICK).group("flag").unlockedBy("has_wool", DDRecipes.has((ItemLike)wool)).save(DDRecipes.withConditions(output, ModCompat.supplementariesFlag("flag")));
        });
    }

    private void dyeConversion(RecipeOutput output, DyeColor dye, ItemLike from, int amount) {
        Item to = this.dyes.getOrThrow(dye);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)to, (int)amount).requires(from).group(String.valueOf(dye) + "_dye").unlockedBy(DDRecipes.getHasName((ItemLike)from), DDRecipes.has((ItemLike)from)).save(output, DyeDepot.modLoc(DDRecipes.getConversionRecipeName((ItemLike)to, (ItemLike)from)));
    }

    private void dyeSmelting(RecipeOutput output, DyeColor dye, TagKey<Item> ingredient) {
        this.dyeSmelting(output, dye, Ingredient.of(ingredient), it -> it.unlockedBy(DDRecipes.getHasName(ingredient), DDRecipes.has((TagKey)ingredient)));
    }

    private void dyeSmelting(RecipeOutput output, DyeColor dye, ItemLike ingredient) {
        this.dyeSmelting(output, dye, Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), it -> it.unlockedBy(DDRecipes.getHasName((ItemLike)ingredient), DDRecipes.has((ItemLike)ingredient)));
    }

    private void dyeSmelting(RecipeOutput output, DyeColor dye, Ingredient ingredient, UnaryOperator<SimpleCookingRecipeBuilder> factory) {
        ((SimpleCookingRecipeBuilder)factory.apply(SimpleCookingRecipeBuilder.smelting((Ingredient)ingredient, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.dyes.getOrThrow(dye)), (float)0.1f, (int)200))).group(String.valueOf(dye) + "_dye").save(output, DyeDepot.modLoc(String.valueOf(dye) + "_dye_from_smelting"));
    }

    private void disable(RecipeOutput output, ResourceLocation id) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DEBUG_STICK).requires((ItemLike)Items.DEBUG_STICK).unlockedBy("never", DDRecipes.has((ItemLike)Items.DEBUG_STICK)).save(DDRecipes.withConditions(output, new ICondition[]{FalseCondition.INSTANCE}), id);
    }

    private void dyeing(RecipeOutput output, RecipeCategory category, DyedHolders<?, ? extends ItemLike> dyed) {
        this.dyeing(output, category, dyed, Ingredient.of(dyed.values().map(ItemStack::new)), builder -> builder.unlockedBy("has_base", DDRecipes.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of((ItemLike[])dyed.values().toArray(ItemLike[]::new)).build()})));
    }

    private void dyeing(RecipeOutput output, RecipeCategory category, DyedHolders<?, ? extends ItemLike> dyed, TagKey<Item> from) {
        this.dyeing(output, category, dyed, Ingredient.of(from), builder -> builder.unlockedBy(DDRecipes.getHasName(from), DDRecipes.has((TagKey)from)));
    }

    private void dyeing(RecipeOutput output, RecipeCategory category, DyedHolders<?, ? extends ItemLike> dyed, Ingredient from, UnaryOperator<ShapelessRecipeBuilder> factory) {
        String group = dyed.detectBaseName();
        dyed.forEach((color, item) -> {
            ResourceLocation id = ((ResourceKey)item.unwrapKey().orElseThrow()).location();
            Item dye = this.dyes.getOrThrow((DyeColor)color);
            ((ShapelessRecipeBuilder)factory.apply(ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)((ItemLike)item.value())))).requires(from).requires((ItemLike)dye).group(group).unlockedBy(DDRecipes.getHasName((ItemLike)dye), DDRecipes.has((ItemLike)dye)).save(output, id.withPrefix("dye_"));
        });
    }

    private void dyeColorSpectrum(RecipeOutput output, DyeColor light, DyeColor base, DyeColor aspect, DyeColor tinted, DyeColor dark) {
        this.lightBaseDark(output, light, base, dark);
        this.dyeHue(output, base, aspect, tinted);
        this.dyeMixing(output, light, tinted, DyeColor.WHITE);
        this.dyeMixing(output, dark, tinted, DyeColor.BLACK);
    }

    private void lightBaseDark(RecipeOutput output, DyeColor light, DyeColor base, DyeColor dark) {
        this.lightenAndDarken(output, light, base);
        this.lightenAndDarken(output, base, dark);
        this.dyeMixing(output, light, dark, DyeColor.WHITE, DyeColor.WHITE);
        this.dyeMixing(output, dark, light, DyeColor.BLACK, DyeColor.BLACK);
        this.dyeMixing(output, base, dark, light);
    }

    private void lightenAndDarken(RecipeOutput output, DyeColor light, DyeColor dark) {
        this.dyeMixing(output, light, dark, DyeColor.WHITE);
        this.dyeMixing(output, dark, light, DyeColor.BLACK);
    }

    private void dyeHue(RecipeOutput output, DyeColor base, DyeColor aspect, DyeColor result) {
        this.dyeMixing(output, result, base, aspect);
        this.dyeMixing(output, base, result, DyeColor.GRAY);
        this.dyeMixing(output, base, result, DyeColor.LIGHT_GRAY);
    }

    private void dyeMixing(RecipeOutput output, DyeColor to, DyeColor ... from) {
        Item result = this.dyes.getOrThrow(to);
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)from.length).group(String.valueOf(to) + "_dye");
        HashSet<DyeColor> unique = new HashSet<DyeColor>();
        for (DyeColor color : from) {
            Item item = this.dyes.getOrThrow(color);
            builder.requires((ItemLike)item);
            if (!unique.add(color)) continue;
            builder.unlockedBy(DDRecipes.getHasName((ItemLike)item), DDRecipes.has((ItemLike)item));
        }
        String name = DDRecipes.getItemName((ItemLike)result) + "_from_" + unique.stream().sorted(Comparator.comparing(DyeColor::getId)).map(DyeColor::getSerializedName).collect(Collectors.joining("_and_"));
        builder.save(output, DyeDepot.modLoc(name));
    }

    public static String getHasName(TagKey<?> tag) {
        return "has_" + tag.location().getPath();
    }

    public static RecipeOutput withConditions(RecipeOutput output, ICondition ... conditions) {
        return output.withConditions(conditions);
    }
}

