/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.registry;

import com.google.common.collect.ImmutableMap;
import com.ninni.dye_depot.registry.DDDyes;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;

public final class DyedHolders<TImplementation extends RRegistry, RRegistry> {
    private final Map<DyeColor, Holder<TImplementation>> entries;

    private DyedHolders(Map<DyeColor, Holder<TImplementation>> entries) {
        this.entries = entries;
    }

    public static <T extends R, R> DyedHolders<T, R> create(Stream<DyeColor> colors, Function<DyeColor, Holder<T>> mapper) {
        Map entries = colors.collect(Collectors.toMap(Function.identity(), mapper));
        return new DyedHolders(entries);
    }

    public static <T extends R, R> DyedHolders<T, R> createModded(Function<DyeColor, Holder<T>> mapper) {
        return DyedHolders.create(Arrays.stream(DDDyes.values()).map(DDDyes::get), mapper);
    }

    @SafeVarargs
    public static <T extends R, R> DyedHolders<T, R> merge(DyedHolders<T, R> ... from) {
        ImmutableMap.Builder entries = ImmutableMap.builder();
        for (DyedHolders<T, R> holders : from) {
            entries.putAll(holders.entries);
        }
        return new DyedHolders(entries.build());
    }

    public static Stream<DyeColor> vanillaColors() {
        return Arrays.stream(DyeColor.values()).filter((? super T it) -> it.getId() < 16);
    }

    public static Stream<DyeColor> modColors() {
        return Arrays.stream(DDDyes.values()).map(DDDyes::get);
    }

    public static <T extends R, R> DyedHolders<T, R> createWithVanilla(Function<DyeColor, Holder<T>> mapper) {
        return DyedHolders.create(Stream.concat(DyedHolders.vanillaColors(), DyedHolders.modColors()), mapper);
    }

    public static <T extends R, R> DyedHolders<T, R> fromRegistry(HolderLookup.RegistryLookup<R> registry, Stream<DyeColor> colors, ResourceLocation baseName) {
        return DyedHolders.fromRegistry(registry, colors, (DyeColor color) -> baseName.withPrefix(String.valueOf(color) + "_"));
    }

    public static <T extends R, R> DyedHolders<T, R> fromRegistry(HolderLookup.RegistryLookup<R> registry, Stream<DyeColor> colors, Function<DyeColor, ResourceLocation> idMapper) {
        ResourceKey registryKey = registry.key();
        Function<DyeColor, ResourceKey<R>> keyMapper = idMapper.andThen(id -> ResourceKey.create((ResourceKey)registryKey, (ResourceLocation)id));
        return DyedHolders.fromLookup(registry, colors, keyMapper);
    }

    public static <T extends R, R> DyedHolders<T, R> fromLookup(HolderLookup<R> registry, Stream<DyeColor> colors, Function<DyeColor, ResourceKey<R>> idMapper) {
        return DyedHolders.create(colors, color -> registry.getOrThrow((ResourceKey)idMapper.apply((DyeColor)color)));
    }

    @Nullable
    public Holder<TImplementation> holderOrNull(DyeColor color) {
        return this.entries.get(color);
    }

    public Optional<Holder<TImplementation>> holder(DyeColor color) {
        return Optional.ofNullable(this.holderOrNull(color));
    }

    @Nullable
    public TImplementation getOrNull(DyeColor color) {
        return this.get(color).orElse(null);
    }

    public Optional<TImplementation> get(DyeColor color) {
        return this.holder(color).map(Holder::value);
    }

    public Holder<TImplementation> holderOrThrow(DyeColor color) {
        return Objects.requireNonNull(this.holderOrNull(color), () -> "holders does not contain block of color " + String.valueOf(color));
    }

    public TImplementation getOrThrow(DyeColor color) {
        return (TImplementation)this.holderOrThrow(color).value();
    }

    public Stream<Holder<TImplementation>> holders() {
        return this.entries.entrySet().stream().sorted(Comparator.comparing(it -> ((DyeColor)it.getKey()).getId())).map(Map.Entry::getValue);
    }

    public Stream<TImplementation> values() {
        return this.holders().map(Holder::value);
    }

    public void forEach(BiConsumer<DyeColor, Holder<TImplementation>> consumer) {
        this.entries.entrySet().stream().sorted(Comparator.comparing(it -> ((DyeColor)it.getKey()).getId())).forEach((? super T it) -> consumer.accept((DyeColor)it.getKey(), (Holder)it.getValue()));
    }

    public <R> Stream<R> map(BiFunction<DyeColor, TImplementation, R> mapper) {
        return this.entries.entrySet().stream().map((? super T it) -> mapper.apply((DyeColor)it.getKey(), ((Holder)it.getValue()).value()));
    }

    public DyedHolders<TImplementation, RRegistry> filter(Supplier<Stream<DyeColor>> colors) {
        return this.filter((DyeColor color, Holder<TImplementation> $) -> ((Stream)colors.get()).anyMatch(it -> it == color));
    }

    public DyedHolders<TImplementation, RRegistry> filter(BiPredicate<DyeColor, Holder<TImplementation>> predicate) {
        ImmutableMap.Builder entries = ImmutableMap.builder();
        this.forEach((color, value) -> {
            if (predicate.test((DyeColor)color, (Holder)value)) {
                entries.put(color, value);
            }
        });
        return new DyedHolders<TImplementation, RRegistry>(entries.build());
    }

    public String detectBaseName() {
        Map.Entry entry = (Map.Entry)this.entries.entrySet().stream().findFirst().orElseThrow(() -> new NoSuchElementException("DyedHolders is empty"));
        ResourceLocation id = ((ResourceKey)((Holder)entry.getValue()).unwrapKey().orElseThrow()).location();
        return Pattern.compile("_?" + String.valueOf(entry.getKey()) + "_?").matcher(id.getPath()).replaceFirst("");
    }

    public DyedHolders<TImplementation, RRegistry> mergeVanilla(HolderLookup.RegistryLookup<RRegistry> registry) {
        String base = this.detectBaseName();
        DyedHolders vanillaVariants = DyedHolders.fromRegistry(registry, DyedHolders.vanillaColors(), ResourceLocation.withDefaultNamespace((String)base));
        return DyedHolders.merge(vanillaVariants, this);
    }
}

