/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data.client;

import com.ninni.dye_depot.data.ModCompat;
import com.ninni.dye_depot.registry.DDBlocks;
import com.ninni.dye_depot.registry.DDItems;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import io.github.fabricators_of_create.porting_lib.models.generators.ItemModelBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.ItemModelProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1767;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7924;

public class DDItemModels
extends ItemModelProvider {
    private final CompletableFuture<class_7225.class_7874> lookup;

    public DDItemModels(class_7784 output, CompletableFuture<class_7225.class_7874> lookup, ExistingFileHelper fileHelper) {
        super(output, "dye_depot", fileHelper);
        this.lookup = lookup;
    }

    protected void registerModels() {
        class_7225.class_7874 lookup = this.lookup.join();
        class_7225.class_7226 itemLookup = lookup.method_46762(class_7924.field_41197);
        DDItems.DYES.holders().forEach(this::basicItem);
        DDBlocks.WOOL.holders().forEach(this::blockReference);
        DDBlocks.CARPETS.holders().forEach(this::blockReference);
        DDBlocks.TERRACOTTA.holders().forEach(this::blockReference);
        DDBlocks.CONCRETE.holders().forEach(this::blockReference);
        DDBlocks.CONCRETE_POWDER.holders().forEach(this::blockReference);
        DDBlocks.GLAZED_TERRACOTTA.holders().forEach(this::blockReference);
        DDBlocks.STAINED_GLASS.holders().forEach(this::blockReference);
        DDBlocks.STAINED_GLASS_PANES.forEach(this::glassPane);
        DDBlocks.SHULKER_BOXES.holders().forEach(this::shulkerBox);
        DDBlocks.CANDLES.holders().forEach(this::basicItem);
        DDBlocks.BANNERS.holders().forEach(this::banner);
        DDBlocks.BEDS.forEach(this::bed);
        DDBlocks.DYE_BASKETS.holders().forEach(this::blockReference);
        ModCompat.supplementariesHolders(itemLookup, "flag").holders().forEach(this::flag);
        ModCompat.supplementariesHolders(itemLookup, "present").forEach(this::present);
        ModCompat.supplementariesHolders(itemLookup, "trapped_present").forEach(this::present);
        ModCompat.supplementariesHolders(itemLookup, "candle_holder").forEach(this::candleHolder);
        ModCompat.supplementariesSquaredHolders(itemLookup, "gold_candle_holder").forEach(this::candleHolder);
    }

    private void basicItem(class_6880<? extends class_1935> item) {
        this.basicItem(((class_1935)item.comp_349()).method_8389());
    }

    private void basicItem(class_6880<? extends class_1935> item, class_2960 texture) {
        ((ItemModelBuilder)this.withExistingParent(this.key(item).toString(), this.vanillaResource("generated"))).texture("layer0", texture);
    }

    private void glassPane(class_1767 color, class_6880<? extends class_1935> item) {
        this.basicItem(item, this.blockTexture(DDBlocks.STAINED_GLASS.holderOrThrow(color)));
    }

    private class_2960 blockTexture(class_6880<? extends class_2248> block) {
        return ((class_5321)block.method_40230().orElseThrow()).method_29177().method_45138("block/");
    }

    private void blockReference(class_6880<? extends class_2248> block) {
        this.withExistingParent(this.name(block), this.blockTexture(block));
    }

    private void shulkerBox(class_6880<? extends class_2248> block) {
        ((ItemModelBuilder)this.withExistingParent(this.name(block), this.vanillaResource("template_shulker_box"))).texture("particle", this.blockTexture(block));
    }

    private void banner(class_6880<? extends class_1935> item) {
        this.withExistingParent(this.name(item), this.vanillaResource("template_banner"));
    }

    private void bed(class_1767 color, class_6880<? extends class_1935> item) {
        ((ItemModelBuilder)this.withExistingParent(this.name(item), this.vanillaResource("template_bed"))).texture("particle", this.blockTexture(DDBlocks.WOOL.holderOrThrow(color)));
    }

    private void candleHolder(class_1767 color, class_6880<? extends class_1935> item) {
        String namespace = this.key(item).method_12836();
        this.basicItem(item, class_2960.method_60655((String)namespace, (String)("item/candle_holders/" + String.valueOf(color))));
    }

    private void flag(class_6880<? extends class_1935> item) {
        this.withExistingParent(this.key(item).toString(), class_2960.method_60655((String)"supplementaries", (String)"item/flag_black"));
    }

    private void present(class_1767 color, class_6880<? extends class_1935> item) {
        String type = this.name(item).replace("_" + String.valueOf(color), "");
        this.withExistingParent(this.key(item).toString(), class_2960.method_60655((String)"supplementaries", (String)("block/" + type + "s/" + String.valueOf(color) + "_closed")));
    }

    private class_2960 vanillaResource(String name) {
        return class_2960.method_60656((String)("item/" + name));
    }

    private String name(class_6880<? extends class_1935> item) {
        return this.key(item).method_12832();
    }

    private class_2960 key(class_6880<? extends class_1935> item) {
        return ((class_5321)item.method_40230().orElseThrow()).method_29177();
    }
}

