/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data.server;

import com.ninni.dye_depot.data.ModCompat;
import com.ninni.dye_depot.registry.DDBlocks;
import com.ninni.dye_depot.registry.DDItems;
import com.ninni.dye_depot.registry.DDTags;
import com.ninni.dye_depot.registry.DyedHolders;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class DDItemTags
extends ItemTagsProvider {
    private final CompletableFuture<HolderLookup.Provider> lookup;

    public DDItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags) {
        super(output, lookup, blockTags, "dye_depot", null);
        this.lookup = lookup;
    }

    protected void addTags(HolderLookup.Provider provider) {
        HolderLookup.Provider lookup = this.lookup.join();
        HolderLookup.RegistryLookup itemLookup = lookup.lookupOrThrow(Registries.ITEM);
        this.groupDyedTag("dyed");
        this.groupDyedTag("dyes");
        this.tagDyed(DDItems.DYES, "dyes", new TagKey[0]);
        this.tagDyed(DDBlocks.SHULKER_BOXES, this.loaderTag("shulker_boxes"));
        this.tagDyed(DDBlocks.BANNERS, ItemTags.BANNERS);
        this.tagDyed(DDBlocks.CARPETS, ItemTags.WOOL_CARPETS);
        this.tagDyed(DDBlocks.CANDLES, ItemTags.CANDLES);
        this.tagDyed(DDBlocks.BEDS, ItemTags.BEDS);
        this.tagDyed(DDBlocks.WOOL, ItemTags.WOOL);
        this.tagDyed(DDBlocks.TERRACOTTA, ItemTags.TERRACOTTA);
        this.tagDyed(DDBlocks.GLAZED_TERRACOTTA, new TagKey[0]);
        this.tagDyed(DDBlocks.CONCRETE, this.loaderTag("concrete"));
        this.tagDyed(DDBlocks.CONCRETE_POWDER, this.loaderTag("concrete_powders"));
        this.tagDyed(DDBlocks.STAINED_GLASS, this.loaderTag("glass_blocks"));
        this.tagDyed(DDBlocks.STAINED_GLASS_PANES, this.loaderTag("glass_panes"));
        this.tagDyed(DDBlocks.DYE_BASKETS, ModTags.SOAP_BLACKLIST_ITEM);
        this.tagDyed(ModCompat.supplementariesHolders(itemLookup, "candle_holder"), this.supplementariesTag("candle_holders"));
        this.tagDyed(ModCompat.supplementariesSquaredHolders(itemLookup, "gold_candle_holder"), this.supplementariesTag("candle_holders"), ItemTags.PIGLIN_LOVED);
        this.tagDyed(ModCompat.supplementariesHolders(itemLookup, "flag"), this.supplementariesTag("flags"));
        this.tagDyed(ModCompat.supplementariesHolders(itemLookup, "present"), this.supplementariesTag("presents"));
        this.tagDyed(ModCompat.supplementariesHolders(itemLookup, "trapped_present"), this.supplementariesTag("trapped_presents"));
        this.tag(DDTags.SMELTS_INTO_CORAL_DYE).add((Object[])new Item[]{Items.TUBE_CORAL, Items.BRAIN_CORAL, Items.BUBBLE_CORAL, Items.FIRE_CORAL, Items.HORN_CORAL, Items.TUBE_CORAL_FAN, Items.BRAIN_CORAL_FAN, Items.BUBBLE_CORAL_FAN, Items.FIRE_CORAL_FAN, Items.HORN_CORAL_FAN, Items.TUBE_CORAL_BLOCK, Items.BRAIN_CORAL_BLOCK, Items.BUBBLE_CORAL_BLOCK, Items.FIRE_CORAL_BLOCK, Items.HORN_CORAL_BLOCK});
    }

    private void tag(DyedHolders<?, ? extends ItemLike> values, TagKey<Item> tag) {
        values.holders().map(it -> ((ResourceKey)it.unwrapKey().orElseThrow()).location()).forEach(it -> this.tag(tag).addOptional(it));
    }

    private void groupDyedTag(String base) {
        Stream.concat(DyedHolders.vanillaColors(), DyedHolders.modColors()).forEach(color -> this.tag(this.loaderTag(base)).addOptionalTag(this.loaderTag(base + "/" + String.valueOf(color))));
    }

    @SafeVarargs
    private void tagDyed(DyedHolders<?, ? extends ItemLike> values, TagKey<Item> ... additionalTags) {
        this.tagDyed(values, "dyed", additionalTags);
    }

    @SafeVarargs
    private void tagDyed(DyedHolders<?, ? extends ItemLike> values, String base, TagKey<Item> ... additionalTags) {
        values.forEach((dye, item) -> {
            ResourceLocation id = ((ResourceKey)item.unwrapKey().orElseThrow()).location();
            TagKey<Item> tag = this.loaderTag(base + "/" + String.valueOf(dye));
            this.tag(tag).addOptional(id);
        });
        for (TagKey<Item> tag : additionalTags) {
            this.tag(values, tag);
        }
    }

    private TagKey<Item> loaderTag(String path) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    private TagKey<Item> supplementariesTag(String path) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"supplementaries", (String)path));
    }
}

