/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data.client;

import com.ninni.dye_depot.data.ModCompat;
import com.ninni.dye_depot.registry.DDBlocks;
import com.ninni.dye_depot.registry.DDItems;
import com.ninni.dye_depot.registry.DyedHolders;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public abstract class DDLangProvider
extends FabricLanguageProvider {
    protected DDLangProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> lookup) {
        super(output, lookup);
    }

    public final void generateTranslations(HolderLookup.Provider lookup, FabricLanguageProvider.TranslationBuilder builder) {
        HolderLookup.RegistryLookup itemLookup = lookup.lookupOrThrow(Registries.ITEM);
        HolderLookup.RegistryLookup blockLookup = lookup.lookupOrThrow(Registries.BLOCK);
        this.colors("general").forEach(color -> {
            builder.add("color.minecraft." + String.valueOf(color), this.translate((DyeColor)color));
            builder.add("item.minecraft.firework_star." + String.valueOf(color), this.translate((DyeColor)color));
            builder.add("item.minecraft.shield." + String.valueOf(color), this.translate((DyeColor)color) + " Shield");
        });
        this.colors("tags").forEach(color -> {
            String translation = this.translate((DyeColor)color);
            this.tag(builder, this.loaderTag(Registries.BLOCK, "dyed/" + String.valueOf(color)), translation + " Dyed Blocks");
            this.tag(builder, this.loaderTag(Registries.ITEM, "dyed/" + String.valueOf(color)), translation + " Dyed Items");
            this.tag(builder, this.loaderTag(Registries.ITEM, "dyes/" + String.valueOf(color)), translation + " Dyes");
        });
        this.dyedBannerPattern(builder, "base", color -> "Fully " + color + " Field");
        this.dyedBannerPattern(builder, "border", color -> color + " Bordure");
        this.dyedBannerPattern(builder, "bricks", color -> color + " Field Masoned");
        this.dyedBannerPattern(builder, "circle", color -> color + " Roundel");
        this.dyedBannerPattern(builder, "creeper", color -> color + " Creeper Charge");
        this.dyedBannerPattern(builder, "cross", color -> color + " Saltire");
        this.dyedBannerPattern(builder, "curly_border", color -> color + " Bordure Indented");
        this.dyedBannerPattern(builder, "diagonal_left", color -> color + " Per Bend Sinister");
        this.dyedBannerPattern(builder, "diagonal_right", color -> color + " Per Bend");
        this.dyedBannerPattern(builder, "diagonal_up_left", color -> color + " Per Bend Inverted");
        this.dyedBannerPattern(builder, "diagonal_up_right", color -> color + " Per Bend Sinister Inverted");
        this.dyedBannerPattern(builder, "flower", color -> color + " Flower Charge");
        this.dyedBannerPattern(builder, "globe", color -> color + " Globe");
        this.dyedBannerPattern(builder, "gradient_up", color -> color + " Base Gradient");
        this.dyedBannerPattern(builder, "gradient", color -> color + " Gradient");
        this.dyedBannerPattern(builder, "half_horizontal_bottom", color -> color + " Per Fess Inverted");
        this.dyedBannerPattern(builder, "half_horizontal", color -> color + " Per Fess");
        this.dyedBannerPattern(builder, "half_vertical_right", color -> color + " Per Pale Inverted");
        this.dyedBannerPattern(builder, "half_vertical", color -> color + " Per Pale");
        this.dyedBannerPattern(builder, "mojang", color -> color + " Thing");
        this.dyedBannerPattern(builder, "piglin", color -> color + " Snout");
        this.dyedBannerPattern(builder, "rhombus", color -> color + " Lozenge");
        this.dyedBannerPattern(builder, "skull", color -> color + " Skull Charge");
        this.dyedBannerPattern(builder, "small_stripes", color -> color + " Paly");
        this.dyedBannerPattern(builder, "square_bottom_left", color -> color + " Base Dexter Canton");
        this.dyedBannerPattern(builder, "square_bottom_right", color -> color + " Base Sinister Canton");
        this.dyedBannerPattern(builder, "square_top_left", color -> color + " Chief Dexter Canton");
        this.dyedBannerPattern(builder, "square_top_right", color -> color + " Chief Sinister Canton");
        this.dyedBannerPattern(builder, "straight_cross", color -> color + " Cross");
        this.dyedBannerPattern(builder, "stripe_bottom", color -> color + " Base");
        this.dyedBannerPattern(builder, "stripe_center", color -> color + " Pale");
        this.dyedBannerPattern(builder, "stripe_downleft", color -> color + " Bend Sinister");
        this.dyedBannerPattern(builder, "stripe_downright", color -> color + " Bend");
        this.dyedBannerPattern(builder, "stripe_left", color -> color + " Pale Dexter");
        this.dyedBannerPattern(builder, "stripe_middle", color -> color + " Fess");
        this.dyedBannerPattern(builder, "stripe_right", color -> color + " Pale Sinister");
        this.dyedBannerPattern(builder, "stripe_top", color -> color + " Chief");
        this.dyedBannerPattern(builder, "triangle_bottom", color -> color + " Chevron");
        this.dyedBannerPattern(builder, "triangle_top", color -> color + " Inverted Chevron");
        this.dyedBannerPattern(builder, "triangles_bottom", color -> color + " Base Indented");
        this.dyedBannerPattern(builder, "triangles_top", color -> color + " Chief Indented");
        this.dyed(builder, this.filterAndMerge(DDItems.DYES, itemLookup), "Dye");
        this.dyed(builder, this.filterAndMerge(DDBlocks.BANNERS, blockLookup), "Banner");
        this.dyed(builder, this.filterAndMerge(DDBlocks.BEDS, blockLookup), "Bed");
        this.dyed(builder, this.filterAndMerge(DDBlocks.CANDLES, blockLookup), "Candle");
        this.dyed(builder, this.filterAndMerge(DDBlocks.CANDLE_CAKES, blockLookup), (String it) -> "Cake with " + it + " Candle");
        this.dyed(builder, this.filterAndMerge(DDBlocks.CARPETS, blockLookup), "Carpet");
        this.dyed(builder, this.filterAndMerge(DDBlocks.CONCRETE, blockLookup), "Concrete");
        this.dyed(builder, this.filterAndMerge(DDBlocks.CONCRETE_POWDER, blockLookup), "Concrete Powder");
        this.dyed(builder, this.filterAndMerge(DDBlocks.GLAZED_TERRACOTTA, blockLookup), "Glazed Terracotta");
        this.dyed(builder, this.filterAndMerge(DDBlocks.SHULKER_BOXES, blockLookup), "Shulker Box");
        this.dyed(builder, this.filterAndMerge(DDBlocks.STAINED_GLASS, blockLookup), "Stained Glass");
        this.dyed(builder, this.filterAndMerge(DDBlocks.STAINED_GLASS_PANES, blockLookup), "Stained Glass Pane");
        this.dyed(builder, this.filterAndMerge(DDBlocks.TERRACOTTA, blockLookup), "Terracotta");
        this.dyed(builder, this.filterAndMerge(DDBlocks.WOOL, blockLookup), "Wool");
        this.dyed(builder, this.filter(DDBlocks.DYE_BASKETS), "Dye Basket");
        this.dyed(builder, this.supplementariesHolders(blockLookup, "present"), "Present");
        this.dyed(builder, this.supplementariesHolders(blockLookup, "trapped_present"), "Trapped Present");
        this.dyed(builder, this.supplementariesHolders(blockLookup, "flag"), "Flag");
        this.dyed(builder, this.supplementariesHolders(blockLookup, "candle_holder"), "Candle Holder");
        this.dyed(builder, this.supplementariesSquaredHolders(blockLookup, "gold_candle_holder"), (String it) -> "Gold " + it + " Candle Holder");
        this.translateAdditional(builder);
    }

    protected void translateAdditional(FabricLanguageProvider.TranslationBuilder builder) {
    }

    protected abstract Stream<DyeColor> colors(String var1);

    protected abstract String translate(DyeColor var1);

    private <R> DyedHolders<R, R> supplementariesHolders(HolderLookup.RegistryLookup<R> registry, String name) {
        return ModCompat.supplementariesHolders(registry, name, this.colors(name));
    }

    private <R> DyedHolders<R, R> supplementariesSquaredHolders(HolderLookup.RegistryLookup<R> registry, String name) {
        return ModCompat.supplementariesSquaredHolders(registry, name, this.colors(name));
    }

    private <T extends R, R> DyedHolders<T, R> filterAndMerge(DyedHolders<T, R> dyed, HolderLookup.RegistryLookup<R> registry) {
        return this.filter(dyed.mergeVanilla(registry));
    }

    private <T extends R, R> DyedHolders<T, R> filter(DyedHolders<T, R> dyed) {
        String baseName = dyed.detectBaseName();
        return dyed.filter(() -> this.colors(baseName));
    }

    private void dyed(FabricLanguageProvider.TranslationBuilder builder, DyedHolders<?, ? extends ItemLike> dyed, String suffix) {
        this.dyed(builder, dyed, (String it) -> it + " " + suffix);
    }

    private void dyed(FabricLanguageProvider.TranslationBuilder builder, DyedHolders<?, ? extends ItemLike> dyed, Function<String, String> translation) {
        dyed.forEach((color, item) -> this.add(builder, (ItemLike)item.value(), (String)translation.apply(this.translate((DyeColor)color))));
    }

    protected void tag(FabricLanguageProvider.TranslationBuilder builder, TagKey<?> tag, String translation) {
        builder.add(tag, translation);
    }

    private void add(FabricLanguageProvider.TranslationBuilder builder, ItemLike item, String translation) {
        if (item instanceof Block) {
            Block block = (Block)item;
            builder.add(block, translation);
        } else {
            builder.add(item.asItem(), translation);
        }
    }

    private void dyedBannerPattern(FabricLanguageProvider.TranslationBuilder builder, String id, Function<String, String> translation) {
        this.colors("banner_patterns").forEach(color -> builder.add("block.minecraft.banner." + id + "." + String.valueOf(color), (String)translation.apply(this.translate((DyeColor)color))));
    }

    private <T> TagKey<T> loaderTag(ResourceKey<Registry<T>> registry, String path) {
        return TagKey.create(registry, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }
}

