/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data.server;

import com.ninni.dye_depot.data.ModCompat;
import com.ninni.dye_depot.registry.DDBlocks;
import com.ninni.dye_depot.registry.DyedHolders;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public class DDBlockTags
extends FabricTagProvider.BlockTagProvider {
    private final CompletableFuture<HolderLookup.Provider> lookup;

    public DDBlockTags(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> lookup) {
        super(output, lookup);
        this.lookup = lookup;
    }

    protected void addTags(HolderLookup.Provider provider) {
        HolderLookup.Provider lookup = this.lookup.join();
        HolderLookup.RegistryLookup blockLookup = lookup.lookupOrThrow(Registries.BLOCK);
        this.groupDyedTag("dyed");
        this.tagDyed(DDBlocks.SHULKER_BOXES, BlockTags.SHULKER_BOXES);
        this.tagDyed(DDBlocks.BANNERS, BlockTags.BANNERS);
        this.tagDyed(DDBlocks.WALL_BANNERS, BlockTags.BANNERS);
        this.tagDyed(DDBlocks.CARPETS, BlockTags.WOOL_CARPETS);
        this.tagDyed(DDBlocks.CANDLES, BlockTags.CANDLES);
        this.tagDyed(DDBlocks.CANDLE_CAKES, BlockTags.CANDLE_CAKES);
        this.tagDyed(DDBlocks.BEDS, BlockTags.BEDS);
        this.tagDyed(DDBlocks.WOOL, BlockTags.WOOL);
        this.tagDyed(DDBlocks.TERRACOTTA, BlockTags.TERRACOTTA, BlockTags.MINEABLE_WITH_PICKAXE);
        this.tagDyed(DDBlocks.GLAZED_TERRACOTTA, BlockTags.MINEABLE_WITH_PICKAXE);
        this.tagDyed(DDBlocks.CONCRETE, BlockTags.MINEABLE_WITH_PICKAXE, this.loaderTag("concretes"));
        this.tagDyed(DDBlocks.CONCRETE_POWDER, BlockTags.MINEABLE_WITH_SHOVEL, BlockTags.CONCRETE_POWDER, BlockTags.CAMEL_SAND_STEP_SOUND_BLOCKS);
        this.tagDyed(DDBlocks.STAINED_GLASS, this.loaderTag("glass_blocks"), BlockTags.IMPERMEABLE);
        this.tagDyed(DDBlocks.STAINED_GLASS_PANES, this.loaderTag("glass_panes"), BlockTags.IMPERMEABLE);
        this.tagDyed(DDBlocks.DYE_BASKETS, BlockTags.MINEABLE_WITH_HOE, ModTags.SOAP_BLACKLIST_BLOCK);
        this.tagDyed(ModCompat.supplementariesHolders(blockLookup, "candle_holder"), this.supplementariesTag("candle_holders"));
        this.tagDyed(ModCompat.supplementariesSquaredHolders(blockLookup, "gold_candle_holder"), this.supplementariesTag("candle_holders"), BlockTags.GUARDED_BY_PIGLINS);
        this.tagDyed(ModCompat.supplementariesHolders(blockLookup, "flag"), this.supplementariesTag("flags"));
        this.tagDyed(ModCompat.supplementariesHolders(blockLookup, "present"), this.supplementariesTag("presents"));
        this.tagDyed(ModCompat.supplementariesHolders(blockLookup, "trapped_present"), this.supplementariesTag("trapped_presents"));
    }

    private void tag(DyedHolders<?, Block> values, TagKey<Block> tag) {
        values.holders().map(it -> ((ResourceKey)it.unwrapKey().orElseThrow()).location()).forEach(it -> this.tag(tag).addOptional(it));
    }

    private void groupDyedTag(String base) {
        Stream.concat(DyedHolders.vanillaColors(), DyedHolders.modColors()).forEach(color -> this.getOrCreateTagBuilder(this.loaderTag(base)).addOptionalTag(this.loaderTag(base + "/" + String.valueOf(color))));
    }

    @SafeVarargs
    private void tagDyed(DyedHolders<?, Block> values, TagKey<Block> ... additionalTags) {
        values.forEach((dye, block) -> {
            ResourceLocation id = ((ResourceKey)block.unwrapKey().orElseThrow()).location();
            TagKey<Block> tag = this.loaderTag("dyed/" + String.valueOf(dye));
            this.tag(tag).addOptional(id);
        });
        for (TagKey<Block> tag : additionalTags) {
            this.tag(values, tag);
        }
    }

    private TagKey<Block> loaderTag(String path) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    private TagKey<Block> supplementariesTag(String path) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"supplementaries", (String)path));
    }
}

