/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;

public class ReplaceDropsModifier
extends LootModifier {
    public static MapCodec<ReplaceDropsModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> ReplaceDropsModifier.codecStart((RecordCodecBuilder.Instance)builder).and((App)SimpleWeightedRandomList.wrappedCodec((Codec)ItemStack.CODEC).fieldOf("items").forGetter(it -> it.items)).apply((Applicative)builder, ReplaceDropsModifier::new));
    private final SimpleWeightedRandomList<ItemStack> items;

    protected ReplaceDropsModifier(LootItemCondition[] conditions, SimpleWeightedRandomList<ItemStack> items) {
        super(conditions);
        this.items = items;
    }

    public static ReplaceDropsModifier forTable(ResourceKey<LootTable> id, float chance, SimpleWeightedRandomList<ItemStack> items) {
        return new ReplaceDropsModifier(new LootItemCondition[]{LootItemRandomChanceCondition.randomChance((float)chance).build(), LootTableIdCondition.builder((ResourceLocation)id.location()).build()}, items);
    }

    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> stacks, LootContext context) {
        Optional item = this.items.getRandomValue(context.getRandom());
        return item.map(it -> {
            ObjectArrayList list = new ObjectArrayList(1);
            list.add(it);
            return list;
        }).orElse(stacks);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

