/*
 * Decompiled with CFR 0.152.
 */
package org.dimayastrebov.torridium;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import org.dimayastrebov.torridium.TorridiumConfig;
import org.slf4j.Logger;

class Chunking {
    private final Map<class_2960, Map<class_1923, Set<class_2338>>> activeHeatSourcesByChunk = new ConcurrentHashMap<class_2960, Map<class_1923, Set<class_2338>>>();
    private final Map<class_2960, Set<class_1923>> chunksToScan = new ConcurrentHashMap<class_2960, Set<class_1923>>();
    public static final Map<class_2248, Double> HEAT_SOURCE_MULTIPLIERS = new HashMap<class_2248, Double>();

    public Chunking() {
        ServerChunkEvents.CHUNK_LOAD.register(this::onChunkLoad);
        ServerChunkEvents.CHUNK_UNLOAD.register(this::onChunkUnload);
    }

    public static void processHeatSourcesConfig(Logger logger) {
        logger.info("-> Processing Heat Sources...");
        HEAT_SOURCE_MULTIPLIERS.clear();
        int successfullyParsed = 0;
        int failedCount = 0;
        for (String s : TorridiumConfig.heatSourceMultipliers) {
            try {
                String[] parts = s.split("=");
                if (parts.length != 2) {
                    logger.warn("Invalid heat source format, skipping: '{}'", (Object)s);
                    ++failedCount;
                    continue;
                }
                class_2960 loc = class_2960.method_60654((String)parts[0]);
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(loc);
                if (block.method_9564().method_26215()) {
                    logger.warn("Could not find block for heat source, skipping: '{}'", (Object)parts[0]);
                    ++failedCount;
                    continue;
                }
                double multiplier = Double.parseDouble(parts[1].trim());
                HEAT_SOURCE_MULTIPLIERS.put(block, multiplier);
                ++successfullyParsed;
            }
            catch (Exception e) {
                logger.error("Failed to parse heat source: '{}'. It will be ignored. Reason: {}", (Object)s, (Object)e.getMessage());
                ++failedCount;
            }
        }
        logger.info("-> Successfully registered {} heat sources.", (Object)successfullyParsed);
        if (failedCount > 0) {
            logger.warn("-> Failed to parse {} entries. Check warnings above.", (Object)failedCount);
        }
    }

    Map<class_2960, Map<class_1923, Set<class_2338>>> getActiveHeatSourcesByChunk() {
        return this.activeHeatSourcesByChunk;
    }

    private Set<class_1923> getChunksToScanForLevel(class_3218 level) {
        return this.chunksToScan.computeIfAbsent(level.method_27983().method_29177(), k -> Collections.synchronizedSet(new HashSet()));
    }

    private Set<class_2338> getSourcesForChunk(class_1937 level, class_1923 chunkPos) {
        return this.activeHeatSourcesByChunk.computeIfAbsent(level.method_27983().method_29177(), k -> new ConcurrentHashMap()).computeIfAbsent(chunkPos, k -> Collections.synchronizedSet(new HashSet()));
    }

    void scanChunk(class_1937 level, class_2818 chunk) {
        if (level.method_8608()) {
            return;
        }
        Set<class_2338> sourcesInChunk = this.getSourcesForChunk(level, chunk.method_12004());
        sourcesInChunk.clear();
        for (class_2338 pos : class_2338.method_10094((int)chunk.method_12004().method_8326(), (int)level.method_31607(), (int)chunk.method_12004().method_8328(), (int)chunk.method_12004().method_8327(), (int)(level.method_31600() - 1), (int)chunk.method_12004().method_8329())) {
            class_2680 state = level.method_8320(pos);
            if (state.method_26215() || !HEAT_SOURCE_MULTIPLIERS.containsKey(state.method_26204())) continue;
            sourcesInChunk.add(pos.method_10062());
        }
    }

    void processChunkScans(class_3218 level) {
        Set<class_1923> chunks = this.getChunksToScanForLevel(level);
        if (chunks.isEmpty()) {
            return;
        }
        Iterator<class_1923> iterator = chunks.iterator();
        while (iterator.hasNext()) {
            class_1923 chunkPos = iterator.next();
            if (level.method_14178().method_12123(chunkPos.field_9181, chunkPos.field_9180)) {
                class_2818 chunk = level.method_8497(chunkPos.field_9181, chunkPos.field_9180);
                this.scanChunk((class_1937)level, chunk);
            }
            iterator.remove();
        }
    }

    private void onChunkLoad(class_3218 level, class_2818 chunk) {
        this.getChunksToScanForLevel(level).add(chunk.method_12004());
    }

    private void onChunkUnload(class_3218 level, class_2818 chunk) {
        class_1923 unloadedChunkPos = chunk.method_12004();
        this.getChunksToScanForLevel(level).remove(unloadedChunkPos);
        Map<class_1923, Set<class_2338>> sourcesInDim = this.activeHeatSourcesByChunk.get(level.method_27983().method_29177());
        if (sourcesInDim != null) {
            sourcesInDim.remove(unloadedChunkPos);
        }
    }

    public void onBlockUpdate(class_2338 pos, class_2680 oldState, class_2680 newState, class_1937 level) {
        boolean isSource;
        if (level.method_8608()) {
            return;
        }
        class_2248 oldBlock = oldState.method_26204();
        class_2248 newBlock = newState.method_26204();
        boolean wasSource = HEAT_SOURCE_MULTIPLIERS.containsKey(oldBlock);
        if (wasSource == (isSource = HEAT_SOURCE_MULTIPLIERS.containsKey(newBlock))) {
            return;
        }
        class_1923 chunkPos = new class_1923(pos);
        Set<class_2338> sourcesInChunk = this.getSourcesForChunk(level, chunkPos);
        if (isSource) {
            sourcesInChunk.add(pos.method_10062());
        } else {
            sourcesInChunk.remove(pos);
        }
    }
}

