/*
 * Decompiled with CFR 0.152.
 */
package org.dimayastrebov.torridium;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2363;
import net.minecraft.class_2429;
import net.minecraft.class_2530;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_3922;
import net.minecraft.class_4538;
import org.dimayastrebov.torridium.Chunking;
import org.dimayastrebov.torridium.HeatPhysics;
import org.dimayastrebov.torridium.HeatReactionRegistry;
import org.dimayastrebov.torridium.Sparking;
import org.dimayastrebov.torridium.Torridium;
import org.dimayastrebov.torridium.TorridiumConfig;
import org.dimayastrebov.torridium.classess.FireTickLimiter;
import org.dimayastrebov.torridium.events.EventManager;
import org.dimayastrebov.torridium.events.IEvent;
import org.dimayastrebov.torridium.mixin.AbstractFurnaceBlockEntityAccessor;
import org.dimayastrebov.torridium.mixin.FireBlockInvoker;

public class HeatManager {
    private static final Map<class_2350, class_2746> PROPERTY_BY_DIRECTION = class_2429.field_11329.entrySet().stream().filter(entry -> entry.getKey() != class_2350.field_11033).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private final Chunking cm = new Chunking();
    private final Sparking sp = new Sparking();
    private Iterator<class_2338> sourceIterator = Collections.emptyIterator();

    public void registerCallbacks() {
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            FireTickLimiter.processedFiresThisTick = 0;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3218 level : server.method_3738()) {
                this.onServerTick(level);
            }
        });
    }

    public void onBlockUpdate(class_2338 pos, class_2680 oldState, class_2680 newState, class_1937 level) {
        this.cm.onBlockUpdate(pos, oldState, newState, level);
    }

    private void onServerTick(class_3218 level) {
        if (!TorridiumConfig.enableMod) {
            return;
        }
        this.sp.tickSparks();
        EventManager.tick(level);
        this.cm.processChunkScans(level);
        int sourcesToProcess = TorridiumConfig.sourcesToCheckPerTick;
        if (sourcesToProcess <= 0) {
            return;
        }
        for (int i = 0; i < sourcesToProcess; ++i) {
            class_2338 sourcePos;
            if (!this.sourceIterator.hasNext()) {
                ArrayList allSources = new ArrayList();
                Map<class_1923, Set<class_2338>> sourcesInDim = this.cm.getActiveHeatSourcesByChunk().get(level.method_27983().method_29177());
                if (sourcesInDim != null) {
                    sourcesInDim.values().forEach(allSources::addAll);
                }
                this.sourceIterator = allSources.iterator();
                if (!this.sourceIterator.hasNext()) break;
            }
            if (!level.method_8477(sourcePos = this.sourceIterator.next())) continue;
            try {
                this.processHeatSource(level, sourcePos);
                continue;
            }
            catch (Exception e) {
                Torridium.LOGGER.error("!!! Critical error while processing heat source at {} !!!", (Object)sourcePos.method_23854());
                Torridium.LOGGER.error("Block: {}", (Object)level.method_8320(sourcePos));
                Torridium.LOGGER.error("This is likely due to a mod conflict or a bug. The source will be skipped. Please report this.", (Throwable)e);
            }
        }
    }

    private void processHeatSource(class_3218 level, class_2338 sourcePos) {
        class_2680 sourceState = level.method_8320(sourcePos);
        class_2248 sourceBlock = sourceState.method_26204();
        if (sourceBlock == class_2246.field_10036) {
            return;
        }
        if (!Chunking.HEAT_SOURCE_MULTIPLIERS.containsKey(sourceBlock) || sourceBlock instanceof class_2363 && !((Boolean)sourceState.method_11654((class_2769)class_2741.field_12548)).booleanValue() || sourceBlock instanceof class_3922 && !((Boolean)sourceState.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            return;
        }
        double multiplier = Chunking.HEAT_SOURCE_MULTIPLIERS.get(sourceBlock);
        class_2586 be = level.method_8321(sourcePos);
        if (be instanceof class_2609) {
            class_2609 furnace = (class_2609)be;
            class_1799 fuel = (class_1799)((AbstractFurnaceBlockEntityAccessor)furnace).getItems().get(1);
            if (fuel.method_31574(class_1802.field_8187)) {
                multiplier *= 2.5;
            } else if (fuel.method_31573(class_3489.field_23212)) {
                multiplier *= 0.8;
            }
        }
        IEvent dominantEvent = EventManager.getDominantEventAt(sourcePos);
        if (TorridiumConfig.enableSparks && sourceBlock instanceof class_3922 && (double)level.field_9229.method_43057() < TorridiumConfig.sparkChance * multiplier * dominantEvent.getSparkChanceMultiplier()) {
            this.sp.launchSpark(level, sourcePos);
        }
        int maxRadius = (int)Math.max(1.0, (double)TorridiumConfig.heatRadius * multiplier * dominantEvent.getHeatRadiusMultiplier());
        Map<class_2338, Integer> affectedBlocks = HeatPhysics.findHeatAffectedBlocksNearby((class_1937)level, sourcePos, maxRadius);
        double baseChance = TorridiumConfig.baseIgnitionChance * multiplier * dominantEvent.getHeatChanceMultiplier();
        affectedBlocks.forEach((pos, distance) -> {
            try {
                double distanceModifier = 1.0 - (double)distance.intValue() / (double)(maxRadius + 1);
                double finalChance = baseChance * distanceModifier;
                HeatManager.applyHeatEffect(level, pos, finalChance);
            }
            catch (Exception e) {
                Torridium.LOGGER.error("!!! Error applying heat effect to block at {} from source at {} !!!", new Object[]{pos.method_23854(), sourcePos.method_23854(), e});
            }
        });
    }

    public static void spreadFireFrom(class_3218 level, class_2338 sourcePos, double ageModifier, IEvent dominantEvent, double radiusMultiplier, double chanceMultiplier) {
        Double baseMultiplier = Chunking.HEAT_SOURCE_MULTIPLIERS.get(class_2246.field_10036);
        if (baseMultiplier == null) {
            baseMultiplier = TorridiumConfig.FireMultiplierDefault;
        }
        double finalMultiplier = baseMultiplier * ageModifier * dominantEvent.getHeatChanceMultiplier();
        int maxRadius = (int)Math.max(1.0, (double)TorridiumConfig.heatRadius * baseMultiplier * dominantEvent.getHeatRadiusMultiplier() * ageModifier * radiusMultiplier);
        double baseChance = TorridiumConfig.baseIgnitionChance * finalMultiplier * chanceMultiplier;
        Map<class_2338, Integer> affectedBlocks = HeatPhysics.findHeatAffectedBlocksNearby((class_1937)level, sourcePos, maxRadius);
        affectedBlocks.forEach((pos, distance) -> {
            double distanceModifier = 1.0 - (double)distance.intValue() / (double)(maxRadius + 1);
            double finalChance = baseChance * distanceModifier;
            HeatManager.applyHeatEffect(level, pos, finalChance);
        });
    }

    static void applyHeatEffect(class_3218 level, class_2338 posToAffect, double chance) {
        if (HeatReactionRegistry.processReaction(level, posToAffect, chance)) {
            return;
        }
        class_2680 stateToAffect = level.method_8320(posToAffect);
        if (stateToAffect.method_26215()) {
            return;
        }
        if (stateToAffect.method_26204() == class_2246.field_10375) {
            if ((double)level.field_9229.method_43057() < chance) {
                class_2530.method_10738((class_1937)level, (class_2338)posToAffect);
            }
            return;
        }
        if (((FireBlockInvoker)class_2246.field_10036).callGetBurnOdds(stateToAffect) > 0 && (double)level.field_9229.method_43057() < chance) {
            HeatManager.igniteBlock(level, posToAffect);
        }
    }

    static void igniteBlock(class_3218 level, class_2338 targetPos) {
        for (class_2350 dir : class_2350.values()) {
            class_2680 fireState;
            class_2338 firePos = targetPos.method_10093(dir);
            if (!level.method_22347(firePos) || (fireState = HeatManager.getFireState(level, firePos)).method_27852(class_2246.field_10124) || !fireState.method_26184((class_4538)level, firePos)) continue;
            level.method_8652(firePos, fireState, 3);
            return;
        }
    }

    private static class_2680 getFireState(class_3218 level, class_2338 pos) {
        class_2680 baseFireState = class_2246.field_10036.method_9564();
        boolean hasFlammableNeighbor = false;
        class_2338 belowPos = pos.method_10074();
        if (level.method_8320(belowPos).method_26206((class_1922)level, belowPos, class_2350.field_11036)) {
            hasFlammableNeighbor = true;
        }
        for (class_2350 direction : class_2350.values()) {
            class_2338 neighborPos;
            class_2746 property = PROPERTY_BY_DIRECTION.get(direction);
            if (property == null || ((FireBlockInvoker)class_2246.field_10036).callGetBurnOdds(level.method_8320(neighborPos = pos.method_10093(direction))) <= 0) continue;
            baseFireState = (class_2680)baseFireState.method_11657((class_2769)property, (Comparable)Boolean.valueOf(true));
            hasFlammableNeighbor = true;
        }
        if (!hasFlammableNeighbor) {
            return class_2246.field_10124.method_9564();
        }
        return baseFireState;
    }
}

