/*
 * Decompiled with CFR 0.152.
 */
package org.dimayastrebov.torridium;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2279;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.dimayastrebov.torridium.IHeatReaction;
import org.dimayastrebov.torridium.TorridiumConfig;
import org.slf4j.Logger;

class HeatReactionRegistry {
    private static final Map<class_2248, IHeatReaction> REACTIONS = new HashMap<class_2248, IHeatReaction>();

    HeatReactionRegistry() {
    }

    public static void rebuildReactions(Logger logger) {
        int before;
        logger.info("-> Rebuilding Heat Reactions...");
        REACTIONS.clear();
        int cooking = 0;
        int cracking = 0;
        int utility = 0;
        int agricultural = 0;
        if (TorridiumConfig.enableCookingReactions) {
            before = 0;
            HeatReactionRegistry.registerCookingReactions();
            cooking = REACTIONS.size() - before;
        }
        if (TorridiumConfig.enableCrackingReactions) {
            before = REACTIONS.size();
            HeatReactionRegistry.registerCrackingReactions();
            cracking = REACTIONS.size() - before;
        }
        if (TorridiumConfig.enableUtilityReactions) {
            before = REACTIONS.size();
            HeatReactionRegistry.registerUtilityReactions();
            utility = REACTIONS.size() - before;
        }
        if (TorridiumConfig.enableAgriculturalReactions) {
            before = REACTIONS.size();
            HeatReactionRegistry.registerAgriculturalReactions();
            agricultural = REACTIONS.size() - before;
        }
        logger.info("   + Cooking: {}, Cracking: {}, Utility: {}, Agricultural: {}", new Object[]{cooking, cracking, utility, agricultural});
        logger.info("   Total reactions active: {}", (Object)REACTIONS.size());
    }

    private static void registerCookingReactions() {
        REACTIONS.put(class_2246.field_10445, (level, pos, state, chance) -> {
            if ((double)level.field_9229.method_43057() < chance * 0.3) {
                level.method_8652(pos, class_2246.field_10340.method_9564(), 3);
                return true;
            }
            return false;
        });
        REACTIONS.put(class_2246.field_10340, (level, pos, state, chance) -> {
            if ((double)level.field_9229.method_43057() < chance * 0.3) {
                level.method_8652(pos, class_2246.field_10360.method_9564(), 3);
                return true;
            }
            return false;
        });
        REACTIONS.put(class_2246.field_10102, (level, pos, state, chance) -> {
            if ((double)level.field_9229.method_43057() < chance * 0.3) {
                level.method_8652(pos, class_2246.field_10033.method_9564(), 3);
                return true;
            }
            return false;
        });
        REACTIONS.put(class_2246.field_10562, (level, pos, state, chance) -> {
            if ((double)level.field_9229.method_43057() < chance * 0.3) {
                level.method_8652(pos, class_2246.field_10258.method_9564(), 3);
                return true;
            }
            return false;
        });
        REACTIONS.put(class_2246.field_10460, (level, pos, state, chance) -> {
            if ((double)level.field_9229.method_43057() < chance * 0.4) {
                level.method_8652(pos, class_2246.field_10415.method_9564(), 3);
                level.method_8396(null, pos, class_3417.field_19198, class_3419.field_15245, 0.5f, 2.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.8f);
                level.method_14199((class_2394)class_2398.field_11203, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.1, (double)pos.method_10260() + 0.5, 5, 0.3, 0.1, 0.3, 0.01);
                return true;
            }
            return false;
        });
    }

    private static void registerCrackingReactions() {
        REACTIONS.put(class_2246.field_10056, (level, pos, state, chance) -> {
            if ((double)level.field_9229.method_43057() < chance * 0.15) {
                level.method_8652(pos, class_2246.field_10416.method_9564(), 3);
                level.method_8396(null, pos, class_3417.field_15026, class_3419.field_15245, 0.4f, 0.8f);
                return true;
            }
            return false;
        });
        REACTIONS.put(class_2246.field_28896, (level, pos, state, chance) -> {
            if ((double)level.field_9229.method_43057() < chance * 0.15) {
                level.method_8652(pos, class_2246.field_29223.method_9564(), 3);
                level.method_8396(null, pos, class_3417.field_28973, class_3419.field_15245, 0.4f, 0.8f);
                return true;
            }
            return false;
        });
        REACTIONS.put(class_2246.field_28900, (level, pos, state, chance) -> {
            if ((double)level.field_9229.method_43057() < chance * 0.15) {
                level.method_8652(pos, class_2246.field_29222.method_9564(), 3);
                level.method_8396(null, pos, class_3417.field_28973, class_3419.field_15245, 0.4f, 0.8f);
                return true;
            }
            return false;
        });
    }

    private static void registerUtilityReactions() {
        REACTIONS.put(class_2246.field_17350, (level, pos, state, chance) -> {
            if (!((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue() && (double)level.field_9229.method_43057() < chance) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)), 3);
                level.method_8396(null, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.4f + 0.8f);
                return true;
            }
            return false;
        });
        REACTIONS.put(class_2246.field_27099, (level, pos, state, chance) -> {
            if (!((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue() && (double)level.field_9229.method_43057() < chance) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)), 3);
                level.method_8396(null, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.4f + 0.8f);
                return true;
            }
            return false;
        });
        REACTIONS.put(class_2246.field_10382, (level, pos, state, chance) -> {
            if ((double)level.field_9229.method_43057() < chance * 0.5) {
                level.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                level.method_8396(null, pos, class_3417.field_19198, class_3419.field_15245, 0.5f, 2.0f);
                return true;
            }
            return false;
        });
        REACTIONS.put(class_2246.field_10528, (level, pos, state, chance) -> {
            if ((Integer)state.method_11654((class_2769)class_2279.field_10762) == 5 && (double)level.field_9229.method_43057() < chance * 0.5) {
                state.method_26204().method_9585((class_1936)level, pos, state);
                level.method_8396(null, pos, class_3417.field_14739, class_3419.field_15245, 1.0f, 1.0f);
                return true;
            }
            return false;
        });
    }

    private static void registerAgriculturalReactions() {
        REACTIONS.put(class_2246.field_10293, (level, pos, state, chance) -> {
            if ((double)level.field_9229.method_43057() < chance * 0.9) {
                level.method_8652(pos, class_2246.field_10428.method_9564(), 3);
                return true;
            }
            return false;
        });
        REACTIONS.put(class_2246.field_10463, (level, pos, state, chance) -> {
            if ((double)level.field_9229.method_43057() < chance * 0.6) {
                level.method_22352(pos, false);
                class_1542 itemEntity = new class_1542((class_1937)level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, new class_1799((class_1935)class_1802.field_8551, 1));
                level.method_8649((class_1297)itemEntity);
                level.method_8396(null, pos, class_3417.field_15222, class_3419.field_15245, 1.0f, 1.5f);
                return true;
            }
            return false;
        });
        REACTIONS.put(class_2246.field_10362, (level, pos, state, chance) -> {
            int currentMoisture = (Integer)state.method_11654((class_2769)class_2344.field_11009);
            if (currentMoisture > 0) {
                if ((double)level.field_9229.method_43057() < chance * 0.9) {
                    level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2344.field_11009, (Comparable)Integer.valueOf(currentMoisture - 1)), 3);
                    level.method_8396(null, pos, class_3417.field_19198, class_3419.field_15245, 0.1f, 2.5f);
                    return true;
                }
            } else if ((double)level.field_9229.method_43057() < chance * 0.5) {
                level.method_8652(pos, class_2246.field_10566.method_9564(), 3);
                level.method_8396(null, pos, class_3417.field_28601, class_3419.field_15245, 0.8f, 1.0f);
                return true;
            }
            return false;
        });
    }

    public static boolean processReaction(class_3218 level, class_2338 posToAffect, double chance) {
        class_2680 stateToAffect = level.method_8320(posToAffect);
        if (stateToAffect.method_26215()) {
            return false;
        }
        IHeatReaction reaction = REACTIONS.get(stateToAffect.method_26204());
        if (reaction != null) {
            return reaction.process(level, posToAffect, stateToAffect, chance);
        }
        return false;
    }
}

