/*
 * Decompiled with CFR 0.152.
 */
package org.dimayastrebov.torridium;

import eu.midnightdust.lib.config.MidnightConfig;
import net.fabricmc.api.ModInitializer;
import org.dimayastrebov.torridium.Chunking;
import org.dimayastrebov.torridium.HeatManager;
import org.dimayastrebov.torridium.HeatReactionRegistry;
import org.dimayastrebov.torridium.TorridiumConfig;
import org.dimayastrebov.torridium.WorldTriggers;
import org.dimayastrebov.torridium.commands.CommandRegistry;
import org.dimayastrebov.torridium.compat.CompatManager;
import org.dimayastrebov.torridium.util.LogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Torridium
implements ModInitializer {
    public static final String MOD_ID = "torridium";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"torridium");
    public static HeatManager heatManager;
    public static final String MOD_VERSION = "3.0.4";

    public void onInitialize() {
        LogHelper.logBlock(LOGGER, "Initializing Torridium v3.0.4 (Fabric)", logger -> {
            logger.info("-> Initializing configs...");
            MidnightConfig.init((String)MOD_ID, TorridiumConfig.class);
            Chunking.processHeatSourcesConfig(logger);
            logger.info("");
            HeatReactionRegistry.rebuildReactions(logger);
            logger.info("-> Initializing managers and registries...");
            heatManager = new HeatManager();
            heatManager.registerCallbacks();
            WorldTriggers.register();
            CommandRegistry.register();
            CompatManager.init();
        });
        LogHelper.info(LOGGER, "Torridium common setup complete. Let the world burn.");
    }
}

