/*
 * Decompiled with CFR 0.152.
 */
package org.dimayastrebov.torridium;

import eu.midnightdust.lib.config.MidnightConfig;
import java.util.List;
import java.util.Locale;

public class TorridiumConfig
extends MidnightConfig {
    public static final String MOD_ID = "torridium";
    public static final Double FireMultiplierDefault = 4.0;
    @MidnightConfig.Comment(centered=true)
    public static MidnightConfig.Comment generalCategory;
    @MidnightConfig.Entry(name="config.torridium.enableMod.title")
    public static boolean enableMod;
    @MidnightConfig.Entry(name="config.torridium.sourcesToCheckPerTick.title", min=0.0, max=2048.0)
    public static int sourcesToCheckPerTick;
    @MidnightConfig.Entry(name="config.torridium.maxFireTicksPerCycle.title", min=10.0, max=2000.0)
    public static int maxFireTicksPerCycle;
    @MidnightConfig.Comment(centered=true)
    public static MidnightConfig.Comment ignitionCategory;
    @MidnightConfig.Entry(name="config.torridium.baseIgnitionChance.title", min=0.0, max=1.0)
    public static double baseIgnitionChance;
    @MidnightConfig.Entry(name="config.torridium.heatRadius.title", min=1.0, max=10.0)
    public static int heatRadius;
    @MidnightConfig.Entry(name="config.torridium.heatSourceMultipliers.title")
    public static List<String> heatSourceMultipliers;
    @MidnightConfig.Entry(name="config.torridium.fireDestructionSpeed.title", min=100.0, max=10000.0)
    public static int fireDestructionSpeed;
    @MidnightConfig.Comment(centered=true)
    public static MidnightConfig.Comment mechanicsCategory;
    @MidnightConfig.Entry(name="config.torridium.faceBurnMultiplier.title", min=0.0, max=1.0)
    public static double faceBurnMultiplier;
    @MidnightConfig.Entry(name="config.torridium.hungryFireRadiusMultiplier.title", min=1.0, max=5.0)
    public static double hungryFireRadiusMultiplier;
    @MidnightConfig.Entry(name="config.torridium.hungryFireChanceMultiplier.title", min=1.0, max=5.0)
    public static double hungryFireChanceMultiplier;
    @MidnightConfig.Comment(centered=true)
    public static MidnightConfig.Comment sparksCategory;
    @MidnightConfig.Entry(name="config.torridium.enableSparks.title")
    public static boolean enableSparks;
    @MidnightConfig.Entry(name="config.torridium.sparkChance.title", min=0.0, max=1.0)
    public static double sparkChance;
    @MidnightConfig.Comment(centered=true)
    public static MidnightConfig.Comment reactionsCategory;
    @MidnightConfig.Entry(name="config.torridium.enableCookingReactions.title")
    public static boolean enableCookingReactions;
    @MidnightConfig.Entry(name="config.torridium.enableCrackingReactions.title")
    public static boolean enableCrackingReactions;
    @MidnightConfig.Entry(name="config.torridium.enableAgriculturalReactions.title")
    public static boolean enableAgriculturalReactions;
    @MidnightConfig.Entry(name="config.torridium.enableUtilityReactions.title")
    public static boolean enableUtilityReactions;
    @MidnightConfig.Comment(centered=true)
    public static MidnightConfig.Comment eventsCategory;
    @MidnightConfig.Entry(name="config.torridium.enableAutomaticEvents.title")
    public static boolean enableAutomaticEvents;

    static {
        enableMod = true;
        sourcesToCheckPerTick = 10;
        maxFireTicksPerCycle = 200;
        baseIgnitionChance = 0.03;
        heatRadius = 1;
        heatSourceMultipliers = List.of("minecraft:furnace=1.0", "minecraft:smoker=0.5", "minecraft:blast_furnace=1.0", "minecraft:soul_torch=1.0", "minecraft:torch=1.0", "minecraft:wall_torch=1.5", "minecraft:magma_block=2.0", String.format(Locale.US, "minecraft:fire=%.1f", FireMultiplierDefault), "minecraft:soul_campfire=2.5", "minecraft:campfire=3.0");
        fireDestructionSpeed = 1500;
        faceBurnMultiplier = 0.25;
        hungryFireRadiusMultiplier = 1.5;
        hungryFireChanceMultiplier = 2.0;
        enableSparks = true;
        sparkChance = 0.15;
        enableCookingReactions = true;
        enableCrackingReactions = true;
        enableAgriculturalReactions = true;
        enableUtilityReactions = true;
        enableAutomaticEvents = true;
    }

    public static class DroughtEvent {
        @MidnightConfig.Entry(name="config.torridium.drought.enable.title")
        public static boolean enabled = true;
        @MidnightConfig.Entry(name="config.torridium.drought.duration.title", min=1.0, max=3600.0)
        public static int duration = 16;
        @MidnightConfig.Entry(name="config.torridium.automaticDroughtChance.title", min=0.0, max=0.1)
        public static double automaticDroughtChance = 5.6E-5;
        @MidnightConfig.Entry(name="config.torridium.drought.heatChanceMultiplier.title", min=1.0, max=20.0)
        public static double heatChanceMultiplier = 3.0;
        @MidnightConfig.Entry(name="config.torridium.drought.heatRadiusMultiplier.title", min=1.0, max=10.0)
        public static double heatRadiusMultiplier = 1.5;
        @MidnightConfig.Entry(name="config.torridium.sparkChanceMultiplier.title", min=1.0, max=20.0)
        public static double sparkChanceMultiplier = 2.5;
    }

    public static class FlashpointEvent {
        @MidnightConfig.Entry(name="config.torridium.flashpoint.enable.title")
        public static boolean enabled = true;
        @MidnightConfig.Entry(name="config.torridium.flashpoint.duration.title", min=1.0, max=3600.0)
        public static int duration = 24;
        @MidnightConfig.Entry(name="config.torridium.flashpoint.radius.title", min=8.0, max=128.0)
        public static int radius = 32;
        @MidnightConfig.Entry(name="config.torridium.flashpoint.heatChanceMultiplier.title", min=1.0, max=20.0)
        public static double heatChanceMultiplier = 5.0;
        @MidnightConfig.Entry(name="config.torridium.flashpoint.heatRadiusMultiplier.title", min=1.0, max=10.0)
        public static double heatRadiusMultiplier = 2.0;
        @MidnightConfig.Entry(name="config.torridium.sparkChanceMultiplier.title", min=1.0, max=20.0)
        public static double sparkChanceMultiplier = 4.0;
    }
}

