/*
 * Decompiled with CFR 0.152.
 */
package org.dimayastrebov.torridium.events;

import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.dimayastrebov.torridium.events.IEvent;
import org.dimayastrebov.torridium.events.TorridiumEvents;

public class ActiveEvent {
    private final IEvent type;
    private final class_2338 center;
    private final double radius;
    private final double radiusSquared;
    private int ticksRemaining;

    public ActiveEvent(IEvent type, class_2338 center, int radius) {
        this.type = type;
        this.center = center;
        this.radius = radius;
        this.radiusSquared = radius * radius;
        this.ticksRemaining = type.getDuration();
    }

    public boolean tick() {
        --this.ticksRemaining;
        return this.ticksRemaining <= 0;
    }

    public boolean isPositionAffected(class_2338 pos) {
        if (!this.type.isLocal()) {
            return true;
        }
        if (this.center == null) {
            return false;
        }
        return pos.method_10262((class_2382)this.center) <= this.radiusSquared;
    }

    public IEvent getEffectiveMultipliers(class_2338 pos) {
        if (!this.type.hasDecay() || !this.type.isLocal() || this.center == null) {
            return this.type;
        }
        double distance = Math.sqrt(pos.method_10262((class_2382)this.center));
        if (distance > this.radius) {
            return TorridiumEvents.NO_EVENT;
        }
        final double decayFactor = 1.0 - distance / this.radius;
        return new IEvent(){

            @Override
            public double getHeatChanceMultiplier() {
                return (ActiveEvent.this.type.getHeatChanceMultiplier() - 1.0) * decayFactor + 1.0;
            }

            @Override
            public double getHeatRadiusMultiplier() {
                return (ActiveEvent.this.type.getHeatRadiusMultiplier() - 1.0) * decayFactor + 1.0;
            }

            @Override
            public double getSparkChanceMultiplier() {
                return (ActiveEvent.this.type.getSparkChanceMultiplier() - 1.0) * decayFactor + 1.0;
            }

            @Override
            public String getEventId() {
                return ActiveEvent.this.type.getEventId();
            }

            @Override
            public int getDuration() {
                return ActiveEvent.this.type.getDuration();
            }

            @Override
            public boolean isLocal() {
                return ActiveEvent.this.type.isLocal();
            }

            @Override
            public boolean hasDecay() {
                return ActiveEvent.this.type.hasDecay();
            }
        };
    }

    public IEvent getType() {
        return this.type;
    }

    public class_2338 getCenter() {
        return this.center;
    }
}

