/*
 * Decompiled with CFR 0.152.
 */
package org.dimayastrebov.torridium.events;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.dimayastrebov.torridium.Torridium;
import org.dimayastrebov.torridium.TorridiumConfig;
import org.dimayastrebov.torridium.events.ActiveEvent;
import org.dimayastrebov.torridium.events.IEvent;
import org.dimayastrebov.torridium.events.TorridiumEvents;

public class EventManager {
    private static final List<ActiveEvent> activeEvents = new CopyOnWriteArrayList<ActiveEvent>();

    public static boolean startEvent(ActiveEvent event, class_3218 level) {
        if (!event.getType().isLocal()) {
            if (EventManager.getGlobalEvent().isPresent()) {
                return false;
            }
            level.method_8396(null, level.method_43126(), class_3417.field_14792, class_3419.field_15252, 1.0f, 1.0f);
        } else if (event.getCenter() != null) {
            level.method_8396(null, event.getCenter(), class_3417.field_14865, class_3419.field_15252, 2.0f, 1.0f);
        }
        activeEvents.add(event);
        return true;
    }

    public static void stopGlobalEvent(class_3218 level) {
        EventManager.getGlobalEvent().ifPresent(activeEvents::remove);
    }

    public static void tick(class_3218 level) {
        if (!activeEvents.isEmpty()) {
            activeEvents.removeIf(ActiveEvent::tick);
        }
        EventManager.tickAutomaticEvents(level);
    }

    private static void tickAutomaticEvents(class_3218 level) {
        ActiveEvent newEvent;
        if (!TorridiumConfig.enableAutomaticEvents || !TorridiumConfig.DroughtEvent.enabled) {
            return;
        }
        if (EventManager.getGlobalEvent().isPresent()) {
            return;
        }
        if ((double)level.field_9229.method_43057() < TorridiumConfig.DroughtEvent.automaticDroughtChance && EventManager.startEvent(newEvent = new ActiveEvent(TorridiumEvents.DROUGHT, null, 0), level)) {
            Torridium.LOGGER.info("A spontaneous 'Drought' event has started.");
        }
    }

    public static IEvent getDominantEventAt(class_2338 pos) {
        IEvent strongestLocalEffect = TorridiumEvents.NO_EVENT;
        for (ActiveEvent event : activeEvents) {
            IEvent effectiveMultipliers;
            if (!event.getType().isLocal() || !event.isPositionAffected(pos) || !((effectiveMultipliers = event.getEffectiveMultipliers(pos)).getHeatChanceMultiplier() > strongestLocalEffect.getHeatChanceMultiplier())) continue;
            strongestLocalEffect = effectiveMultipliers;
        }
        if (strongestLocalEffect != TorridiumEvents.NO_EVENT) {
            return strongestLocalEffect;
        }
        return EventManager.getGlobalEvent().map(ActiveEvent::getType).orElse(TorridiumEvents.NO_EVENT);
    }

    public static Optional<ActiveEvent> getGlobalEvent() {
        return activeEvents.stream().filter(e -> !e.getType().isLocal()).findFirst();
    }
}

