/*
 * Decompiled with CFR 0.152.
 */
package org.dimayastrebov.torridium.events;

import org.dimayastrebov.torridium.TorridiumConfig;
import org.dimayastrebov.torridium.events.IEvent;

public enum TorridiumEvents implements IEvent
{
    NO_EVENT("none", false, false),
    DROUGHT("drought", false, false),
    FLASHPOINT("flashpoint", true, true);

    private final String eventId;
    private final boolean isLocal;
    private final boolean hasDecay;

    private TorridiumEvents(String eventId, boolean isLocal, boolean hasDecay) {
        this.eventId = eventId;
        this.isLocal = isLocal;
        this.hasDecay = hasDecay;
    }

    public static TorridiumEvents fromId(String id) {
        for (TorridiumEvents event : TorridiumEvents.values()) {
            if (!event.getEventId().equalsIgnoreCase(id)) continue;
            return event;
        }
        return NO_EVENT;
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    @Override
    public int getDuration() {
        return switch (this.ordinal()) {
            case 2 -> TorridiumConfig.FlashpointEvent.duration * 20;
            case 1 -> TorridiumConfig.DroughtEvent.duration * 20;
            default -> -1;
        };
    }

    @Override
    public double getHeatChanceMultiplier() {
        return switch (this.ordinal()) {
            case 2 -> TorridiumConfig.FlashpointEvent.heatChanceMultiplier;
            case 1 -> TorridiumConfig.DroughtEvent.heatChanceMultiplier;
            default -> 1.0;
        };
    }

    @Override
    public double getHeatRadiusMultiplier() {
        return switch (this.ordinal()) {
            case 2 -> TorridiumConfig.FlashpointEvent.heatRadiusMultiplier;
            case 1 -> TorridiumConfig.DroughtEvent.heatRadiusMultiplier;
            default -> 1.0;
        };
    }

    @Override
    public double getSparkChanceMultiplier() {
        return switch (this.ordinal()) {
            case 2 -> TorridiumConfig.FlashpointEvent.sparkChanceMultiplier;
            case 1 -> TorridiumConfig.DroughtEvent.sparkChanceMultiplier;
            default -> 1.0;
        };
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public boolean hasDecay() {
        return this.hasDecay;
    }
}

