/*
 * Decompiled with CFR 0.152.
 */
package org.dimayastrebov.torridium.mixin;

import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4770;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.dimayastrebov.torridium.HeatManager;
import org.dimayastrebov.torridium.TorridiumConfig;
import org.dimayastrebov.torridium.classess.FireTickLimiter;
import org.dimayastrebov.torridium.compat.SupplementariesCompat;
import org.dimayastrebov.torridium.events.EventManager;
import org.dimayastrebov.torridium.events.IEvent;
import org.dimayastrebov.torridium.events.TorridiumEvents;
import org.dimayastrebov.torridium.mixin.FireBlockInvoker;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2358.class})
public abstract class FireBlockMixin
extends class_4770 {
    @Shadow
    @Final
    private static Map<class_2350, class_2746> field_11090;

    public FireBlockMixin(class_4970.class_2251 properties, float damage) {
        super(properties, damage);
    }

    @Inject(method={"tick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onFireTick(class_2680 state, class_3218 level, class_2338 pos, class_5819 random, CallbackInfo ci) {
        if (!TorridiumConfig.enableMod) {
            return;
        }
        ci.cancel();
        int maxFires = TorridiumConfig.maxFireTicksPerCycle;
        if (FireTickLimiter.processedFiresThisTick >= maxFires) {
            level.method_39279(pos, (class_2248)this, 1);
            return;
        }
        ++FireTickLimiter.processedFiresThisTick;
        class_2680 updatedState = this.torridium$getUpdatedFireState((class_1936)level, pos, state);
        if (!updatedState.method_27852((class_2248)this)) {
            level.method_8652(pos, updatedState, 3);
            return;
        }
        state = updatedState;
        class_2680 blockBelowState = level.method_8320(pos.method_10074());
        boolean isEternal = blockBelowState.method_26164(level.method_8597().comp_654());
        boolean isFuelStarved = !isEternal && !this.torridium$isNearFlammable((class_1936)level, pos);
        int age = (Integer)state.method_11654((class_2769)class_2741.field_12498);
        if (!isEternal) {
            if (isFuelStarved) {
                age += random.method_43048(2) + 1;
            } else if (age < 15 && random.method_43048(3) == 0) {
                ++age;
            }
            if (age >= 15) {
                level.method_8650(pos, false);
                return;
            }
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12498, (Comparable)Integer.valueOf(age));
        }
        IEvent dominantEvent = EventManager.getDominantEventAt(pos);
        boolean isProtectedFromRain = dominantEvent.getEventId().equals(TorridiumEvents.FLASHPOINT.getEventId());
        if (level.method_8419() && level.method_8520(pos) && !isProtectedFromRain) {
            class_1959.class_1963 precipitation = ((class_1959)level.method_23753(pos).comp_349()).method_48162(pos);
            if (precipitation == class_1959.class_1963.field_9382) {
                if (random.method_43057() < 0.6f) {
                    level.method_8650(pos, false);
                    return;
                }
            } else if (precipitation == class_1959.class_1963.field_9383 && random.method_43057() < 0.3f) {
                level.method_8650(pos, false);
                return;
            }
        }
        level.method_8652(pos, state, 4);
        double radiusMultiplier = isFuelStarved ? TorridiumConfig.hungryFireRadiusMultiplier : 1.0;
        double chanceMultiplier = isFuelStarved ? TorridiumConfig.hungryFireChanceMultiplier : 1.0;
        double ageModifier = 1.0 - (double)age / 20.0;
        HeatManager.spreadFireFrom(level, pos, ageModifier, dominantEvent, radiusMultiplier, chanceMultiplier);
        this.torridium$trySpreadAndBurn(level, pos, random);
        level.method_39279(pos, (class_2248)this, 30 + random.method_43048(20));
    }

    @Unique
    private void torridium$trySpreadAndBurn(class_3218 level, class_2338 firePos, class_5819 random) {
        for (class_2350 dir : class_2350.values()) {
            class_2338 neighborPos = firePos.method_10093(dir);
            if (((FireBlockInvoker)class_2246.field_10036).callGetBurnOdds(level.method_8320(neighborPos)) <= 0) continue;
            this.torridium$processFuelBlock(level, neighborPos, random);
        }
    }

    @Unique
    private boolean torridium$isNearFlammable(class_1936 level, class_2338 pos) {
        for (class_2350 dir : class_2350.values()) {
            if (((FireBlockInvoker)class_2246.field_10036).callGetBurnOdds(level.method_8320(pos.method_10093(dir))) <= 0) continue;
            return true;
        }
        return false;
    }

    @Unique
    private void torridium$processFuelBlock(class_3218 level, class_2338 fuelPos, class_5819 random) {
        int totalOpenFaces = 0;
        int burningFaces = 0;
        for (class_2350 dir : class_2350.values()) {
            class_2338 adjacentPos = fuelPos.method_10093(dir);
            class_2680 adjacentState = level.method_8320(adjacentPos);
            if (adjacentState.method_26216((class_1922)level, adjacentPos)) continue;
            ++totalOpenFaces;
            if (!adjacentState.method_27852((class_2248)this)) continue;
            ++burningFaces;
        }
        if (totalOpenFaces == 0) {
            return;
        }
        float burnChance = (float)burningFaces / (float)totalOpenFaces * (float)TorridiumConfig.faceBurnMultiplier;
        if (random.method_43057() < burnChance) {
            class_2680 fuelState = level.method_8320(fuelPos);
            SupplementariesCompat.tryPlaceAshInsteadOfBlock(level, fuelPos, fuelState);
        }
    }

    @Unique
    private class_2680 torridium$getUpdatedFireState(class_1936 level, class_2338 pos, class_2680 currentState) {
        boolean canSurvive;
        class_2338 below = pos.method_10074();
        boolean bl = canSurvive = level.method_8320(below).method_26206((class_1922)level, below, class_2350.field_11036) || this.torridium$isNearFlammable(level, pos);
        if (!canSurvive) {
            return class_2246.field_10124.method_9564();
        }
        class_2680 newState = currentState;
        for (class_2350 dir : class_2350.values()) {
            class_2746 prop = field_11090.get(dir);
            if (prop == null) continue;
            boolean isFlammable = ((FireBlockInvoker)class_2246.field_10036).callGetBurnOdds(level.method_8320(pos.method_10093(dir))) > 0;
            newState = (class_2680)newState.method_11657((class_2769)prop, (Comparable)Boolean.valueOf(isFlammable));
        }
        return newState;
    }
}

