/*
 * Decompiled with CFR 0.152.
 */
package org.dimayastrebov.torridium.util;

import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class LogHelper {
    private static final String LINE = "==================================================";
    private static final Pattern PATTERN = Pattern.compile("\\$\\{(.*?)}");

    public static void logBlock(Logger logger, String title, Consumer<Logger> content) {
        logger.info(LINE);
        logger.info(title);
        logger.info("");
        content.accept(logger);
        logger.info(LINE);
    }

    public static void info(Logger logger, String message, Map<String, Object> values) {
        logger.info(LogHelper.replacePlaceholders(message, values));
    }

    public static void info(Logger logger, String message) {
        logger.info(message);
    }

    private static String replacePlaceholders(String text, Map<String, Object> values) {
        Matcher matcher = PATTERN.matcher(text);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String key = matcher.group(1);
            Object value = values.getOrDefault(key, "${" + key + "}");
            matcher.appendReplacement(result, Matcher.quoteReplacement(String.valueOf(value)));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

