/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.item.nightmare;

import com.ytgld.seeking_immortals.Handler;
import com.ytgld.seeking_immortals.init.Effects;
import com.ytgld.seeking_immortals.init.Items;
import com.ytgld.seeking_immortals.item.nightmare.super_nightmare.extend.INightmare;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class immortal
extends Item
implements ICurioItem,
INightmare {
    public immortal(Item.Properties properties) {
        super(properties);
    }

    public static void hEvt(LivingIncomingDamageEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                int lvl = Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)100);
                if (Handler.hascurio((LivingEntity)player, (Item)Items.immortal.get()) && lvl <= 80) {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    if (living.getHealth() <= living.getMaxHealth() * 0.7f) {
                        living.hurt(living.damageSources().dryOut(), event.getAmount() * 0.5f);
                        event.setAmount(0.0f);
                    } else {
                        living.invulnerableTime = 0;
                        living.hurt(living.damageSources().dryOut(), event.getAmount() * 1.5f);
                        event.setAmount(0.0f);
                    }
                }
            }
        }
    }

    public static void livDead(LivingDeathEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity living = (LivingEntity)entity;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player && Handler.hascurio((LivingEntity)(player = (Player)livingEntity), (Item)Items.immortal.get())) {
                living.hurt(living.damageSources().dryOut(), living.getHealth() * 0.2f);
                living.addEffect(new MobEffectInstance(Effects.dead, 200, 9));
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Vec3 playerPos = player.position().add(0.0, 0.75, 0.0);
            int range = 8;
            List entities = player.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
            for (LivingEntity living : entities) {
                if (living.is((Entity)player) || player.tickCount % 100 != 1) continue;
                living.addEffect(new MobEffectInstance(Effects.dead, 600, 0));
                if (living.getEffect(Effects.dead) == null) continue;
                if (living.getEffect(Effects.dead).getAmplifier() < 5) {
                    living.addEffect(new MobEffectInstance(Effects.dead, 600, living.getEffect(Effects.dead).getAmplifier() + 1));
                    continue;
                }
                living.addEffect(new MobEffectInstance(Effects.dead, 600, 5));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltip, flag);
        if (Screen.hasShiftDown()) {
            tooltip.accept((Component)Component.literal((String)""));
            tooltip.accept((Component)Component.translatable((String)"item.immortal.tool.string").withStyle(ChatFormatting.RED));
            tooltip.accept((Component)Component.translatable((String)"item.immortal.tool.string.1").withStyle(ChatFormatting.RED));
            tooltip.accept((Component)Component.literal((String)""));
            tooltip.accept((Component)Component.translatable((String)"item.immortal.tool.string.2").withStyle(ChatFormatting.RED));
            tooltip.accept((Component)Component.translatable((String)"item.immortal.tool.string.3").withStyle(ChatFormatting.RED));
            tooltip.accept((Component)Component.literal((String)""));
            tooltip.accept((Component)Component.translatable((String)"item.immortal.tool.string.4").withStyle(ChatFormatting.RED));
            tooltip.accept((Component)Component.literal((String)""));
            tooltip.accept((Component)Component.translatable((String)"item.immortal.tool.string.5").withStyle(ChatFormatting.RED));
        } else {
            tooltip.accept((Component)Component.translatable((String)"key.keyboard.left.shift").withStyle(ChatFormatting.DARK_RED));
            tooltip.accept((Component)Component.literal((String)""));
            tooltip.accept((Component)Component.translatable((String)"item.immortal.tool.string.6").withStyle(ChatFormatting.DARK_RED).withStyle(ChatFormatting.BOLD));
            tooltip.accept((Component)Component.translatable((String)"item.immortal.tool.string.7").withStyle(ChatFormatting.DARK_RED).withStyle(ChatFormatting.BOLD));
            tooltip.accept((Component)Component.translatable((String)"item.immortal.tool.string.8").withStyle(ChatFormatting.DARK_RED).withStyle(ChatFormatting.BOLD));
        }
    }
}

