/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.item.nightmare.super_nightmare;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.seeking_immortals.Config;
import com.ytgld.seeking_immortals.Handler;
import com.ytgld.seeking_immortals.init.DataReg;
import com.ytgld.seeking_immortals.init.Items;
import com.ytgld.seeking_immortals.item.nightmare.super_nightmare.extend.nightmare;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import top.theillusivec4.curios.api.CurioAttributeModifiers;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class nightmare_base
extends nightmare {
    public int tick = 0;

    public nightmare_base(Item.Properties properties) {
        super(properties);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        slotContext.entity().getAttributes().removeAttributeModifiers(this.gets(slotContext));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().getAttributes().addTransientAttributeModifiers(this.gets(slotContext));
        this.tick = 100;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (stack.get(DataReg.tag) == null) {
            slotContext.entity().level().playSound(null, slotContext.entity().getX(), slotContext.entity().getY(), slotContext.entity().getZ(), SoundEvents.ELDER_GUARDIAN_CURSE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            stack.set(DataReg.tag, (Object)new CompoundTag());
        }
        if (!((CompoundTag)stack.get(DataReg.tag)).getBoolean("canDo").isPresent()) {
            Random random = new Random();
            ArrayList<Item> items = new ArrayList<Item>(List.of((Item)Items.nightmare_base_stone.get(), (Item)Items.nightmare_base_reversal.get(), (Item)Items.nightmare_base_black_eye.get(), (Item)Items.nightmare_base_redemption.get(), (Item)Items.nightmare_base_fool.get(), (Item)Items.nightmare_base_insight.get(), (Item)Items.nightmare_base_start.get()));
            for (int i = 0; i < (Integer)Config.SERVER.nightmareBaseMaxItem.get(); ++i) {
                if (items.isEmpty()) continue;
                int index = random.nextInt(items.size());
                Item selectedItem = items.remove(index);
                this.addLoot((Entity)slotContext.entity(), selectedItem, stack);
            }
            ((CompoundTag)stack.get(DataReg.tag)).putBoolean("canDo", true);
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> gets(SlotContext slotContext) {
        HashMultimap linkedHashMultimap = HashMultimap.create();
        float s = -0.3f;
        if (Handler.hascurio(slotContext.entity(), (Item)Items.nightmare_base_reversal_mysterious.get())) {
            s = 0.0f;
        }
        if (Handler.hascurio(slotContext.entity(), (Item)Items.nightmare_base_redemption_down_and_out.get())) {
            s += 0.35f;
        }
        if (Handler.hascurio(slotContext.entity(), (Item)Items.nightmare_base_redemption.get())) {
            s -= 0.15f;
        }
        linkedHashMultimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        linkedHashMultimap.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        linkedHashMultimap.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return linkedHashMultimap;
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (CuriosApi.getCuriosInventory((LivingEntity)player).isPresent() && ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get()).isEquipped((Item)Items.immortal.get())) {
                return true;
            }
            if (player.isCreative()) {
                return true;
            }
        }
        return false;
    }

    private void addLoot(Entity entity, Item itemList, ItemStack stack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.get(DataReg.tag) != null) {
                player.addItem(itemList.getDefaultInstance());
            }
        }
    }

    public CurioAttributeModifiers getDefaultCurioAttributeModifiers(ItemStack stack) {
        return CurioAttributeModifiers.builder().addSlotModifier("nightmare", new AttributeModifier(ResourceLocation.parse((String)this.getDescriptionId()), 3.0, AttributeModifier.Operation.ADD_VALUE)).build();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> pTooltipComponents, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, pTooltipComponents, flag);
        pTooltipComponents.accept((Component)Component.translatable((String)"item.nightmare_base.tool.string").withStyle(ChatFormatting.DARK_RED));
    }
}

