/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.mixin.client;

import com.mojang.blaze3d.resource.CrossFrameResourcePool;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.ytgld.seeking_immortals.Handler;
import com.ytgld.seeking_immortals.init.Items;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    @Final
    private Camera mainCamera;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private static ResourceLocation BLUR_POST_CHAIN_ID;
    @Shadow
    @Final
    private CrossFrameResourcePool resourcePool;

    @Inject(at={@At(value="RETURN")}, method={"render"})
    public void init(DeltaTracker deltaTracker, boolean renderLevel, CallbackInfo ci) {
        Player player;
        Entity entity = this.mainCamera.getEntity();
        if (entity instanceof Player && Handler.hascurio((LivingEntity)(player = (Player)entity), (Item)Items.nightmare_base_black_eye.get())) {
            if (player.getPersistentData().getFloat("blurEffectOFNightmare_base_black_eye").isPresent()) {
                PostChain postchain;
                float f = ((Float)player.getPersistentData().getFloat("blurEffectOFNightmare_base_black_eye").get()).floatValue();
                if (this.moonstone1_21_1$getPlayerLookTarget(player.level(), (LivingEntity)player) != null && this.moonstone1_21_1$getPlayerLookTarget(player.level(), (LivingEntity)player) instanceof LivingEntity) {
                    if (f < 5.0f) {
                        player.getPersistentData().putFloat("blurEffectOFNightmare_base_black_eye", f + 0.1f);
                    }
                } else if (f > 0.0f) {
                    player.getPersistentData().putFloat("blurEffectOFNightmare_base_black_eye", f - 0.05f);
                }
                if (!(f < 1.0f) && (postchain = this.minecraft.getShaderManager().getPostChain(BLUR_POST_CHAIN_ID, LevelTargetBundle.MAIN_TARGETS)) != null) {
                    postchain.process(this.minecraft.getMainRenderTarget(), (GraphicsResourceAllocator)this.resourcePool, p_409027_ -> p_409027_.setUniform("Radius", new float[]{f}));
                }
            } else {
                player.getPersistentData().putFloat("blurEffectOFNightmare_base_black_eye", 0.0f);
            }
        }
    }

    @Unique
    public Entity moonstone1_21_1$getPlayerLookTarget(Level level, LivingEntity living) {
        Entity pointedEntity = null;
        double range = 20.0;
        Vec3 srcVec = living.getEyePosition();
        Vec3 lookVec = living.getViewVector(1.0f);
        Vec3 destVec = srcVec.add(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range);
        float var9 = 1.0f;
        List possibleList = level.getEntities((Entity)living, living.getBoundingBox().expandTowards(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range).inflate((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.isPickable()) continue;
            float borderSize = possibleEntity.getPickRadius();
            AABB collisionBB = possibleEntity.getBoundingBox().inflate((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.clip(srcVec, destVec);
            if (collisionBB.contains(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.distanceTo((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }
}

