/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.mixin.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ytgld.seeking_immortals.init.Items;
import com.ytgld.seeking_immortals.renderer.MRender;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementWidget;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AdvancementTab.class})
public abstract class ATabMixin {
    @Shadow
    @Final
    private AdvancementWidget root;
    @Shadow
    @Final
    private ItemStack icon;
    @Shadow
    private boolean centered;
    @Shadow
    private double scrollX;
    @Shadow
    private double scrollY;
    @Shadow
    private int maxX;
    @Shadow
    private int minX;
    @Shadow
    private int minY;
    @Shadow
    private int maxY;
    @Shadow
    @Final
    private DisplayInfo display;

    @Inject(at={@At(value="RETURN")}, method={"drawContents(Lnet/minecraft/client/gui/GuiGraphics;II)V"})
    public void drawContents(GuiGraphics guiGraphics, int x, int y, CallbackInfo ci) {
        if (this.icon.is(Items.nightmare_base)) {
            if (!this.centered) {
                this.scrollX = 117 - (this.maxX + this.minX) / 2;
                this.scrollY = 56 - (this.maxY + this.minY) / 2;
                this.centered = true;
            }
            guiGraphics.enableScissor(x, y, x + 234, y + 113);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)x, (float)y, 0.0f);
            ResourceLocation resourcelocation = this.display.getBackground().orElse(TextureManager.INTENTIONAL_MISSING_TEXTURE);
            int i = Mth.floor((double)this.scrollX);
            int j = Mth.floor((double)this.scrollY);
            int k = i % 16;
            int l = j % 16;
            for (int i1 = -1; i1 <= 15; ++i1) {
                for (int j1 = -1; j1 <= 8; ++j1) {
                    this.seekingImmortals$blit(guiGraphics, resourcelocation, k + 16 * i1, l + 16 * j1, 0.0f, 0.0f, 16, 16, 16, 16);
                }
            }
            this.root.drawConnectivity(guiGraphics, i, j, true);
            this.root.drawConnectivity(guiGraphics, i, j, false);
            this.root.draw(guiGraphics, i, j);
            guiGraphics.pose().popPose();
            guiGraphics.disableScissor();
        }
    }

    @Unique
    void seekingImmortals$innerBlit(GuiGraphics guiGraphics, ResourceLocation atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        VertexConsumer vertexConsumer = guiGraphics.bufferSource().getBuffer(MRender.ging());
        guiGraphics.pose().pushPose();
        vertexConsumer.addVertex(matrix4f, (float)x1, (float)y1, (float)blitOffset).setUv(minU, minV);
        vertexConsumer.addVertex(matrix4f, (float)x1, (float)y2, (float)blitOffset).setUv(minU, maxV);
        vertexConsumer.addVertex(matrix4f, (float)x2, (float)y2, (float)blitOffset).setUv(maxU, maxV);
        vertexConsumer.addVertex(matrix4f, (float)x2, (float)y1, (float)blitOffset).setUv(maxU, minV);
        guiGraphics.pose().popPose();
    }

    @Unique
    void seekingImmortals$blit(GuiGraphics guiGraphics, ResourceLocation atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        this.seekingImmortals$innerBlit(guiGraphics, atlasLocation, x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight);
    }

    @Unique
    public void seekingImmortals$blit(GuiGraphics guiGraphics, ResourceLocation atlasLocation, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.seekingImmortals$blit(guiGraphics, atlasLocation, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    @Unique
    public void seekingImmortals$blit(GuiGraphics guiGraphics, ResourceLocation atlasLocation, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        this.seekingImmortals$blit(guiGraphics, atlasLocation, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight);
    }
}

