/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.shiftthedev.pickablepets.PickablePetsClient;
import com.shiftthedev.pickablepets.blocks.ReviveAltarBlockEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class ReviveAltarRenderer
implements BlockEntityRenderer<ReviveAltarBlockEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/end_crystal/end_crystal.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private final ModelPart glass;
    private final ModelPart cube;

    public ReviveAltarRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.bakeLayer(PickablePetsClient.ALTAR_BALL);
        this.glass = modelPart.getChild("glass");
        this.cube = modelPart.getChild("cube");
    }

    public static LayerDefinition createBallLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("glass", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void render(ReviveAltarBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        poseStack.pushPose();
        float h = ReviveAltarRenderer.getY(blockEntity, f);
        float j = ((float)blockEntity.time + f) * 3.0f;
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RENDER_TYPE);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int k = OverlayTexture.NO_OVERLAY;
        poseStack.mulPose(Axis.YP.rotationDegrees(j));
        poseStack.translate(0.0, (double)(1.5f + h / 2.0f), 0.0);
        poseStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        this.glass.render(poseStack, vertexConsumer, light, k);
        poseStack.scale(0.875f, 0.875f, 0.875f);
        poseStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        poseStack.mulPose(Axis.YP.rotationDegrees(j));
        this.glass.render(poseStack, vertexConsumer, light, k);
        poseStack.scale(0.875f, 0.875f, 0.875f);
        poseStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        poseStack.mulPose(Axis.YP.rotationDegrees(j));
        this.cube.render(poseStack, vertexConsumer, light, k);
        poseStack.popPose();
        poseStack.popPose();
    }

    public static float getY(ReviveAltarBlockEntity blockEntity, float f) {
        float g = (float)blockEntity.time + f;
        float h = Mth.sin((float)(g * 0.2f)) / 2.0f + 0.5f;
        h = (h * h + h) * 0.4f;
        return h - 1.4f;
    }
}

