/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.shiftthedev.pickablepets.PickablePets;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PetButton
extends Button {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"pickablepets", (String)"textures/gui/altar.png");
    private static final MutableComponent ALIVE = Component.translatable((String)"gui.pickablepets.alive");
    private static final MutableComponent DEAD = Component.translatable((String)"gui.pickablepets.dead");
    private int index;
    private UUID petID;

    public PetButton(int i, int j, int index, UUID petID, Button.OnPress onPress) {
        super(i, j, 88, 20, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.index = index;
        this.petID = petID;
        this.visible = false;
    }

    public int getIndex() {
        return this.index;
    }

    public UUID getPetID() {
        return this.petID;
    }

    public void updateButton(UUID petID, int index) {
        this.petID = petID;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        int offset = 0;
        if (this.isHovered()) {
            offset = this.isFocused() ? 40 : 20;
        } else if (this.isFocused()) {
            offset = 60;
        }
        guiGraphics.blit(TEXTURE, this.getX(), this.getY(), this.getWidth(), this.getHeight(), 80.0f, (float)(176 + offset), this.width, this.height, 512, 256);
        guiGraphics.drawString(font, PickablePets.CACHE.getEntityName(this.petID), this.getX() + 3, this.getY() + 3, 0xFFFFFF);
        boolean isAlive = PickablePets.CACHE.isPetAlive(this.petID);
        MutableComponent text = isAlive ? ALIVE : DEAD;
        FormattedCharSequence formattedCharSequence = text.getVisualOrderText();
        int n = this.getX() + this.width - font.width(formattedCharSequence) - 3;
        int n2 = this.getY();
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, (Component)text, n, n2 + 9, isAlive ? 0x78FF78 : 0xFF7878);
    }
}

