/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.containers;

import com.shiftthedev.pickablepets.PPRegistry;
import com.shiftthedev.pickablepets.blocks.ReviveAltarBlockEntity;
import com.shiftthedev.pickablepets.containers.ReviveSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ReviveAltarContainer
extends AbstractContainerMenu {
    private final Level level;
    private final ReviveAltarBlockEntity reviveAltarBlockEntity;
    private Slot reviveSlot;

    public ReviveAltarContainer(int id, Level level, BlockPos worldPosition, Inventory inventory, Player player) {
        super((MenuType)PPRegistry.REVIVE_ALTAR_MENU.get(), id);
        this.level = level;
        this.reviveAltarBlockEntity = (ReviveAltarBlockEntity)this.level.getBlockEntity(worldPosition);
        this.initSlots(inventory);
    }

    private void initSlots(Inventory inventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)inventory, column + row * 9 + 9, 107 + column * 18, 82 + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.addSlot(new Slot((Container)inventory, slot, 107 + slot * 18, 140));
        }
        this.reviveSlot = this.addSlot(new ReviveSlot((Container)this.reviveAltarBlockEntity, 0, 171, 52));
    }

    public BlockPos getBlockPosition() {
        return this.reviveAltarBlockEntity.getBlockPos();
    }

    public boolean hasReviveCurrency() {
        return this.reviveSlot.hasItem() && !this.reviveSlot.getItem().isEmpty();
    }

    public ItemStack quickMoveStack(Player player, int i) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (i >= 0 && i < 36 && this.moveItemStackTo(slotStack, 36, 37, false)) {
                return itemStack;
            }
            if (i >= 0 && i < 27 ? !this.moveItemStackTo(slotStack, 27, 36, false) : (i >= 27 && i < 36 ? !this.moveItemStackTo(slotStack, 0, 27, false) : !this.moveItemStackTo(slotStack, 0, 36, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return this.reviveAltarBlockEntity.stillValid(player);
    }
}

