/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.data;

import com.shiftthedev.alexandria.Alexandria;
import com.shiftthedev.alexandria.data.CachedEntities;
import com.shiftthedev.alexandria.data.EntityDataComponent;
import com.shiftthedev.alexandria.network.RequestUpdatePacket;
import com.shiftthedev.alexandria.registry.CommonRegistry;
import com.shiftthedev.pickablepets.PPRegistry;
import com.shiftthedev.pickablepets.data.ItemTagFixer;
import com.shiftthedev.pickablepets.data.PetDataComponent;
import com.shiftthedev.pickablepets.data.PetInfo;
import com.shiftthedev.pickablepets.data.PlayerPets;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class CachedPets
extends CachedEntities<LivingEntity, PetInfo> {
    public CachedPets() {
        super(PetInfo::new);
    }

    public String getKey() {
        return "pets";
    }

    protected ItemStack fixIfNeeded(ItemStack stack, Level level) {
        if (stack.has((DataComponentType)PPRegistry.PET_DATA_COMPONENT.get())) {
            PetDataComponent oldData = (PetDataComponent)stack.get((DataComponentType)PPRegistry.PET_DATA_COMPONENT.get());
            stack.set((DataComponentType)CommonRegistry.ENTITY_DATA_COMPONENT.get(), (Object)new EntityDataComponent(oldData.tag, oldData.version));
            stack.remove((DataComponentType)PPRegistry.PET_DATA_COMPONENT.get());
        }
        return stack;
    }

    public void uncache(UUID entityID, @Nullable Level level) {
    }

    protected boolean extraChecks(LivingEntity entity) {
        return entity instanceof OwnableEntity;
    }

    public boolean isValidPet(UUID petID) {
        return this.cachedEntities.containsKey(petID);
    }

    public LivingEntity getPet(UUID petID) {
        if (this.cachedEntities.containsKey(petID)) {
            return ((PetInfo)((Object)this.cachedEntities.get(petID))).getEntity();
        }
        return null;
    }

    public List<UUID> getPetsFrom(UUID ownerID) {
        ArrayList<UUID> pets = new ArrayList<UUID>();
        this.cachedEntities.forEach((uuid, petInfo) -> {
            if (ownerID.equals(((OwnableEntity)petInfo.getEntity()).getOwnerUUID())) {
                pets.add((UUID)uuid);
            }
        });
        return pets;
    }

    @OnlyIn(value=Dist.CLIENT)
    public LivingEntity getRender(UUID entityID) {
        if (this.cachedEntities.containsKey(entityID)) {
            return ((PetInfo)((Object)this.cachedEntities.get(entityID))).getEntity();
        }
        RequestUpdatePacket.sendToServer((UUID)entityID, (String)"pets");
        return null;
    }

    public void updateOldStack(ItemStack itemStack, Level level) {
        Optional entityType;
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        if (level.isClientSide) {
            return;
        }
        CustomData customData = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return;
        }
        CompoundTag customTag = customData.copyTag();
        if (!customTag.contains("pet_info", 10)) {
            return;
        }
        CompoundTag oldTag = customTag.getCompound("pet_info");
        customTag.remove("pet_info");
        if (customTag.isEmpty()) {
            itemStack.remove(DataComponents.CUSTOM_DATA);
        } else {
            itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customTag));
        }
        if (oldTag.contains("pp_type")) {
            oldTag.putString("entity_type", oldTag.getString("pp_type"));
            oldTag.remove("pp_type");
        }
        if ((entityType = EntityType.byString((String)(oldTag = ItemTagFixer.fixItemTag(oldTag)).getString("pet_type"))).isEmpty()) {
            return;
        }
        LivingEntity entity = (LivingEntity)((EntityType)entityType.get()).create(overworldLevel);
        if (entity == null) {
            return;
        }
        if (!(entity instanceof OwnableEntity)) {
            return;
        }
        entity.load(oldTag);
        if (this.cachedEntities.containsKey(entity.getUUID()) && oldTag.getInt("VERSION") == 1) {
            ((PetInfo)((Object)this.cachedEntities.get(entity.getUUID()))).updateAttributes(entity);
        }
        CompoundTag newTag = new CompoundTag();
        entity.save(newTag);
        EntityDataComponent dataComponent = EntityDataComponent.fromTag((CompoundTag)newTag);
        itemStack.set((DataComponentType)CommonRegistry.ENTITY_DATA_COMPONENT.get(), (Object)dataComponent);
        if (newTag.contains("custom_name")) {
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)newTag.getString("custom_name")));
        } else if (itemStack.has(DataComponents.CUSTOM_NAME)) {
            itemStack.remove(DataComponents.CUSTOM_NAME);
        }
        this.cache(entity);
        ((PetInfo)((Object)this.cachedEntities.get(entity.getUUID()))).setInItem(true);
    }

    public String getOwner(UUID uuid) {
        if (this.cachedEntities.containsKey(uuid)) {
            return ((PetInfo)((Object)this.cachedEntities.get(uuid))).getOwner();
        }
        return "";
    }

    public ListTag getPetAttributes(UUID petUUID) {
        if (this.cachedEntities.containsKey(petUUID)) {
            return ((PetInfo)((Object)this.cachedEntities.get(petUUID))).getAttributes();
        }
        return new ListTag();
    }

    public void setPetItem(UUID uuid, boolean flag) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return;
        }
        ((PetInfo)((Object)this.cachedEntities.get(uuid))).setInItem(flag);
    }

    public boolean isInItem(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return false;
        }
        return ((PetInfo)((Object)this.cachedEntities.get(uuid))).isInItem();
    }

    public void killPet(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return;
        }
        ((PetInfo)((Object)this.cachedEntities.get(uuid))).markDead();
    }

    public void revivePet(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return;
        }
        ((PetInfo)((Object)this.cachedEntities.get(uuid))).revive();
    }

    public void replaceWolf(ServerPlayer player, UUID oldID, TamableAnimal dog) {
        if (dog.getUUID().equals(oldID) && this.cachedEntities.containsKey(dog.getUUID())) {
            ((PetInfo)((Object)this.cachedEntities.get(dog.getUUID()))).updateEntity((LivingEntity)dog);
            return;
        }
        this.cachedEntities.remove(oldID);
        Level level = dog.level();
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        if (dog.getOwnerUUID() == null) {
            return;
        }
        this.cachedEntities.put(dog.getUUID(), new PetInfo((LivingEntity)dog));
        Path path = level.getServer().getWorldPath(new LevelResource("data/pets"));
        path = path.resolve(dog.getOwnerUUID().toString() + ".pets");
        PlayerPets.replacePetAsync(path, oldID.toString(), dog.getUUID().toString());
        this.sendRemoveEntity(level, oldID);
        this.sendCachedEntity(player, dog.getUUID());
    }

    public boolean isPetAlive(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return false;
        }
        return ((PetInfo)((Object)this.cachedEntities.get(uuid))).isAlive();
    }

    public void setUpdated(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return;
        }
        ((PetInfo)((Object)this.cachedEntities.get(uuid))).setUpdated();
    }

    public boolean isPetUpdated(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return false;
        }
        return ((PetInfo)((Object)this.cachedEntities.get(uuid))).isUpdated();
    }

    public boolean wasPetRevived(UUID uuid) {
        if (!this.cachedEntities.containsKey(uuid)) {
            return false;
        }
        return ((PetInfo)((Object)this.cachedEntities.get(uuid))).wasRevived();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void receiveRemoveEntity(UUID entityID) {
    }

    public void save(Path path) {
        ListTag listTag = new ListTag();
        TreeMap<UUID, PetInfo> tempMap = new TreeMap<UUID, PetInfo>();
        for (Map.Entry petEntry : this.cachedEntities.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.putUUID("Key", (UUID)petEntry.getKey());
            entryTag.put("Value", (Tag)((PetInfo)((Object)petEntry.getValue())).save(new CompoundTag()));
            listTag.add((Object)entryTag);
            tempMap.put((UUID)petEntry.getKey(), (PetInfo)((Object)petEntry.getValue()));
        }
        this.cachedEntities.clear();
        this.cachedEntities = new TreeMap();
        this.cachedEntities.putAll(tempMap);
        CompoundTag tagToSave = new CompoundTag();
        tagToSave.put("pets", (Tag)listTag);
        tagToSave.putInt("version", Alexandria.VERSION);
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        Path file = path.resolve("pets.shift");
        try {
            NbtIo.writeCompressed((CompoundTag)tagToSave, (Path)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void load(Path path, MinecraftServer server) {
        CompoundTag tag;
        this.cachedEntities = new TreeMap();
        boolean old = false;
        Path file = path.resolve("pets.shift");
        Path oldFile = path.resolve("pets.dat");
        if (!file.toFile().exists()) {
            if (!oldFile.toFile().exists()) {
                return;
            }
            file = oldFile;
            old = true;
        }
        try {
            tag = NbtIo.readCompressed((Path)file, (NbtAccounter)NbtAccounter.unlimitedHeap());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (tag == null) {
            return;
        }
        if (!tag.contains("pets")) {
            return;
        }
        this.cachedEntities.clear();
        ListTag listTag = tag.getList("pets", 10);
        for (Tag entry : listTag) {
            if (!(entry instanceof CompoundTag)) continue;
            CompoundTag entryTag = (CompoundTag)entry;
            CompoundTag value = entryTag.getCompound("Value");
            UUID petId = entryTag.getUUID("Key");
            PetInfo petEntry = (PetInfo)this.createEntityInfo(null);
            petEntry.load(petId, value, overworldLevel);
            this.cachedEntities.put(petId, petEntry);
        }
        if (old) {
            oldFile.toFile().delete();
            this.save(path);
        }
    }
}

