/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.items;

import com.shiftthedev.alexandria.data.EntityDataComponent;
import com.shiftthedev.alexandria.items.LivingEntityItem;
import com.shiftthedev.alexandria.mixins.EntityAccessor;
import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.compat.DoggyHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PetItem
extends LivingEntityItem<LivingEntity> {
    public PetItem(Item.Properties properties) {
        super(properties);
    }

    public String getKey() {
        return "pets";
    }

    protected InteractionResult place(LivingEntity entity, ItemStack stack, BlockPos blockPos, BlockState blockState, Direction direction, ServerPlayer player, ServerLevel level) {
        if (!(entity instanceof Allay) && !player.getUUID().equals(((OwnableEntity)entity).getOwnerUUID())) {
            return InteractionResult.FAIL;
        }
        if (!blockState.getCollisionShape((BlockGetter)level, blockPos).isEmpty()) {
            blockPos = direction == Direction.DOWN ? blockPos.relative(direction, 2) : blockPos.relative(direction);
        }
        BlockPos finalBlockPos = blockPos;
        level.getServer().execute(() -> {
            if (PickablePets.FoundDoggy && DoggyHelper.isFromMod(entity)) {
                LivingEntity dog = DoggyHelper.reviveDog(entity, entity.getUUID(), (Player)player, level, finalBlockPos);
                if (dog == null) {
                    return;
                }
                if (player.isCreative()) {
                    player.getInventory().removeItem(stack);
                } else {
                    stack.setCount(0);
                }
            } else {
                entity.setPos(Vec3.atCenterOf((Vec3i)finalBlockPos));
                ((EntityAccessor)entity).invokeSetLevel((Level)level);
                ((EntityAccessor)entity).setRemovalReason(null);
                if (!level.addFreshEntity((Entity)entity)) {
                    return;
                }
                if (player.isCreative()) {
                    player.getInventory().removeItem(stack);
                } else {
                    stack.setCount(0);
                }
                PickablePets.CACHE.cache(entity);
            }
            PickablePets.CACHE.setPetItem(entity.getUUID(), false);
            level.getProfiler().pop();
        });
        return InteractionResult.SUCCESS;
    }

    public void onDestroyed(ItemEntity itemEntity) {
        if (itemEntity.level().isClientSide) {
            return;
        }
        ServerLevel level = (ServerLevel)itemEntity.level();
        EntityDataComponent data = EntityDataComponent.get((ItemStack)itemEntity.getItem(), (Level)level);
        if (data == null) {
            return;
        }
        UUID entityID = data.getTag().getUUID("UUID");
        PickablePets.CACHE.killPet(entityID);
        PickablePets.CACHE.sendToAll(itemEntity.level(), entityID);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void appendExtraText(List<Component> list, EntityDataComponent data, ItemStack itemStack) {
        if (!data.getTag().hasUUID("UUID")) {
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.pickablepets.owner", (Object[])new Object[]{PickablePets.CACHE.getOwner(data.getTag().getUUID("UUID"))}));
    }
}

