/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.mixins;

import com.shiftthedev.pickablepets.PickablePets;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public Level level;

    @Shadow
    public abstract UUID getUUID();

    @Shadow
    public abstract EntityType<?> getType();

    @Inject(method={"remove(Lnet/minecraft/world/entity/Entity$RemovalReason;)V"}, at={@At(value="HEAD")})
    private void remove_Impl(Entity.RemovalReason removalReason, CallbackInfo ci) {
        UUID entityID;
        if (!this.level.isClientSide && removalReason == Entity.RemovalReason.KILLED && PickablePets.CACHE.isValidPet(entityID = this.getUUID())) {
            PickablePets.CACHE.killPet(entityID);
            PickablePets.CACHE.sendToAll(this.level, entityID);
        }
    }
}

