/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.mixins;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.data.ItemTagFixer;
import com.shiftthedev.pickablepets.data.PlayerPets;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TamableAnimal.class})
public abstract class TamableAnimalMixin
extends Animal
implements OwnableEntity {
    @Shadow
    @Nullable
    public abstract UUID getOwnerUUID();

    protected TamableAnimalMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tame(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/advancements/critereon/TameAnimalTrigger;trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/entity/animal/Animal;)V", shift=At.Shift.AFTER)})
    private void tame_pets(Player player, CallbackInfo ci) {
        String entityKey;
        if (!(this.level().isClientSide || PickablePets.CONFIG.BlacklistedPets.contains(entityKey = EntityType.getKey((EntityType)this.getType()).toString()) || PickablePets.CONFIG.BlacklistedMods.contains(entityKey.split(":")[0]))) {
            UUID owner = this.getOwnerUUID();
            if (owner == null) {
                return;
            }
            UUID petID = this.getUUID();
            PickablePets.CACHE.cache((LivingEntity)((TamableAnimal)this));
            PickablePets.CACHE.setUpdated(petID);
            MinecraftServer server = ((ServerLevel)this.level()).getServer();
            Path path = server.getWorldPath(new LevelResource("data/pets"));
            path = path.resolve(owner.toString() + ".pets");
            PlayerPets.addPetAsync(path, petID.toString());
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void readAdditionalSaveData_pets(CompoundTag compoundTag, CallbackInfo ci) {
        if (!this.level().isClientSide) {
            if (!compoundTag.contains("dog_reviving")) {
                String entityKey = EntityType.getKey((EntityType)this.getType()).toString();
                if (!PickablePets.CONFIG.BlacklistedPets.contains(entityKey) && !PickablePets.CONFIG.BlacklistedMods.contains(entityKey.split(":")[0]) && !PickablePets.CACHE.isPetUpdated(this.getUUID()) && (compoundTag = ItemTagFixer.fixItemTag(compoundTag)).hasUUID("Owner")) {
                    UUID player = compoundTag.getUUID("Owner");
                    UUID petID = this.getUUID();
                    PickablePets.CACHE.cache((LivingEntity)((TamableAnimal)this));
                    PickablePets.CACHE.setUpdated(petID);
                    MinecraftServer server = ((ServerLevel)this.level()).getServer();
                    Path path = server.getWorldPath(new LevelResource("data/pets"));
                    path = path.resolve(player.toString() + ".pets");
                    PlayerPets.saveOldPet(petID.toString(), path);
                }
            } else {
                compoundTag.remove("dog_reviving");
            }
        }
    }
}

