/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.network;

import com.shiftthedev.pickablepets.client.gui.ReviveAltarScreen;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AltarUpdatePacket {
    private static final ResourceLocation PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"pickablepets", (String)"altar_update");
    private static final CustomPacketPayload.Type<AltarUpdatePayload> TYPE = new CustomPacketPayload.Type(PACKET_ID);
    private static final StreamCodec<FriendlyByteBuf, AltarUpdatePayload> CODEC = StreamCodec.ofMember(AltarUpdatePayload::write, AltarUpdatePayload::read);

    public static void register() {
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType(TYPE, CODEC);
        } else {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), TYPE, CODEC, AltarUpdatePacket::receive);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void receive(AltarUpdatePayload payload, NetworkManager.PacketContext context) {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (!(screen instanceof ReviveAltarScreen)) {
            return;
        }
        ReviveAltarScreen altarScreen = (ReviveAltarScreen)screen;
        altarScreen.populatePetList(payload.petsIDS.stream().map(UUID::fromString).collect(Collectors.toList()));
    }

    public static void sendToPlayer(ServerPlayer player, List<String> pets) {
        if (player == null) {
            return;
        }
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new AltarUpdatePayload(pets));
    }

    private record AltarUpdatePayload(List<String> petsIDS) implements CustomPacketPayload
    {
        public void write(FriendlyByteBuf buf) {
            buf.writeInt(this.petsIDS.size());
            this.petsIDS.forEach(arg_0 -> ((FriendlyByteBuf)buf).writeUtf(arg_0));
        }

        public static AltarUpdatePayload read(FriendlyByteBuf buf) {
            ArrayList<String> temp = new ArrayList<String>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                temp.add(buf.readUtf());
            }
            return new AltarUpdatePayload(temp);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

