/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.network;

import com.shiftthedev.alexandria.mixins.EntityAccessor;
import com.shiftthedev.alexandria.network.ClientUpdatePacket;
import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.blocks.ReviveAltarBlockEntity;
import com.shiftthedev.pickablepets.compat.DoggyHelper;
import com.shiftthedev.pickablepets.data.PetInfo;
import com.shiftthedev.pickablepets.network.ChatPacket;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RevivePacket {
    private static final ResourceLocation PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"pickablepets", (String)"revive");
    private static final CustomPacketPayload.Type<RevivePayload> TYPE = new CustomPacketPayload.Type(PACKET_ID);
    private static final StreamCodec<FriendlyByteBuf, RevivePayload> CODEC = StreamCodec.ofMember(RevivePayload::write, RevivePayload::read);

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), TYPE, CODEC, RevivePacket::receive);
    }

    public static void receive(RevivePayload payload, NetworkManager.PacketContext context) {
        if (context.getPlayer().isLocalPlayer()) {
            return;
        }
        UUID petID = payload.petId;
        BlockPos revivePos = payload.revivePos;
        Level level = context.getPlayer().level();
        LivingEntity cachedPet = PickablePets.CACHE.getPet(petID);
        if (cachedPet == null || PickablePets.CACHE.isPetAlive(petID)) {
            return;
        }
        BlockPos spanwPos = null;
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffeset = -2; zOffeset <= 2; ++zOffeset) {
                if (!level.noCollision(cachedPet.getType().getSpawnAABB((double)(revivePos.getX() + xOffset), (double)revivePos.getY(), (double)(revivePos.getZ() + zOffeset)))) continue;
                spanwPos = new BlockPos(revivePos.getX() + xOffset, revivePos.getY(), revivePos.getZ() + zOffeset);
                break;
            }
            if (spanwPos != null) break;
        }
        if (spanwPos == null) {
            ChatPacket.sendToPlayer((ServerPlayer)context.getPlayer(), "spawn");
            return;
        }
        BlockPos finalSpanwPos = spanwPos;
        level.getServer().execute(() -> {
            BlockEntity be;
            if (PickablePets.FoundDoggy && DoggyHelper.isFromMod(cachedPet)) {
                LivingEntity pet = DoggyHelper.reviveDog(cachedPet, petID, context.getPlayer(), (ServerLevel)level, finalSpanwPos);
                if (pet == null) {
                    return;
                }
            } else {
                LivingEntity pet = (LivingEntity)cachedPet.getType().create(level);
                if (pet == null) {
                    return;
                }
                ((EntityAccessor)cachedPet).setRemovalReason(null);
                ((EntityAccessor)cachedPet).invokeSetLevel(level);
                CompoundTag tag = cachedPet.saveWithoutId(new CompoundTag());
                tag.putBoolean("Sitting", false);
                tag.putShort("DeathTime", (short)0);
                cachedPet.load(tag);
                pet.restoreFrom((Entity)cachedPet);
                pet.getAttributes().load(PickablePets.CACHE.getPetAttributes(cachedPet.getUUID()));
                pet.setPos(Vec3.atCenterOf((Vec3i)finalSpanwPos));
                pet.setHealth(cachedPet.getMaxHealth());
                if (!level.addFreshEntity((Entity)pet)) {
                    return;
                }
                PickablePets.CACHE.revivePet(petID);
                PickablePets.CACHE.cache(pet);
            }
            if ((be = level.getChunkAt(revivePos).getBlockEntity(revivePos, LevelChunk.EntityCreationType.IMMEDIATE)) instanceof ReviveAltarBlockEntity) {
                ReviveAltarBlockEntity rbe = (ReviveAltarBlockEntity)be;
                ItemStack stack = rbe.getItem(0).copy();
                stack.shrink(1);
                rbe.setItem(0, stack);
            }
            level.players().forEach(p -> ClientUpdatePacket.sendToPlayer((UUID)petID, (CompoundTag)((PetInfo)PickablePets.CACHE.getEntityInfo(petID)).save(new CompoundTag()), (String)"pets", (ServerPlayer)((ServerPlayer)p)));
            level.getProfiler().pop();
        });
    }

    private record RevivePayload(UUID petId, BlockPos revivePos) implements CustomPacketPayload
    {
        public void write(FriendlyByteBuf buf) {
            buf.writeUUID(this.petId);
            buf.writeBlockPos(this.revivePos);
        }

        public static RevivePayload read(FriendlyByteBuf buf) {
            return new RevivePayload(buf.readUUID(), buf.readBlockPos());
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        public static void sendToServer(UUID petID, BlockPos revivePos) {
            NetworkManager.sendToServer((CustomPacketPayload)new RevivePayload(petID, revivePos));
        }
    }
}

