/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.blocks;

import com.shiftthedev.alexandria.blocks.ContainerBlockEntity;
import com.shiftthedev.pickablepets.PPRegistry;
import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.containers.ReviveAltarContainer;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ReviveAltarBlockEntity
extends ContainerBlockEntity {
    public int time;

    public ReviveAltarBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PPRegistry.REVIVE_ALTAR_BLOCKENTITY.get(), blockPos, blockState);
        this.items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        this.SLOTS_FOR_UP = new int[]{0};
        this.displayName = Component.translatable((String)"block.pickablepets.altar");
        this.time = new Random().nextInt(100000);
    }

    protected boolean isValidInput(int slotIndex, ItemStack itemStack) {
        if (PickablePets.CONFIG.ReviveAltarReviveItem.startsWith("#")) {
            return itemStack.is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryParse((String)PickablePets.CONFIG.ReviveAltarReviveItem.substring(1))));
        }
        if (itemStack.getItem().arch$registryName() == null) {
            return false;
        }
        if (!itemStack.getItem().arch$registryName().toString().equals(PickablePets.CONFIG.ReviveAltarReviveItem)) {
            return false;
        }
        if (PickablePets.CONFIG.ReviveItemNBT.isEmpty()) {
            return true;
        }
        if (itemStack.getComponents() == DataComponentMap.EMPTY) {
            return false;
        }
        return Objects.equals(itemStack.getComponents().toString(), PickablePets.CONFIG.ReviveItemNBT);
    }

    public static <A extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, A blockEntity) {
        if (!(blockEntity instanceof ReviveAltarBlockEntity)) {
            return;
        }
        ReviveAltarBlockEntity reviveAltarBlockEntity = (ReviveAltarBlockEntity)blockEntity;
        ++reviveAltarBlockEntity.time;
        reviveAltarBlockEntity.markUpdated();
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putInt("timer", this.time);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        if (compoundTag == null) {
            return;
        }
        if (compoundTag.contains("timer")) {
            this.time = compoundTag.getInt("timer");
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new ReviveAltarContainer(i, this.level, this.worldPosition, player.getInventory(), player);
    }
}

