/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.client.gui.AltarButton;
import com.shiftthedev.pickablepets.client.gui.PetButton;
import com.shiftthedev.pickablepets.containers.ReviveAltarContainer;
import com.shiftthedev.pickablepets.network.AltarRequestPacket;
import com.shiftthedev.pickablepets.network.RevivePacket;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReviveAltarScreen
extends AbstractContainerScreen<ReviveAltarContainer> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"pickablepets", (String)"textures/gui/altar.png");
    private int petItem;
    private int scrollOff;
    private boolean isDragging;
    private boolean isLoading;
    private List<UUID> petIDS;
    private PetButton[] petButtons;
    private AltarButton selectButton;
    private AltarButton reviveButton;

    public ReviveAltarScreen(ReviveAltarContainer reviveAltarContainer, Inventory inventory, Component component) {
        super((AbstractContainerMenu)reviveAltarContainer, inventory, component);
        this.imageWidth = 276;
        this.inventoryLabelX = 107;
    }

    protected void init() {
        super.init();
        this.selectButton = (AltarButton)this.addRenderableWidget((GuiEventListener)new AltarButton(193 + this.leftPos, 51 + this.topPos, true, (Component)Component.translatable((String)"gui.pickablepets.select"), button -> {}));
        this.selectButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.pickablepets.select.tooltip")));
        this.reviveButton = (AltarButton)this.addRenderableWidget((GuiEventListener)new AltarButton(193 + this.leftPos, 51 + this.topPos, false, (Component)Component.translatable((String)"gui.pickablepets.revive"), button -> this.reviveButtonClick()));
        this.reviveButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.pickablepets.revive.tooltip")));
        this.isLoading = true;
        this.petItem = -1;
        AltarRequestPacket.Client.sendToServer();
    }

    public void populatePetList(List<UUID> newPetList) {
        if (!newPetList.isEmpty()) {
            this.petIDS = newPetList;
            int i = (this.width - this.imageWidth) / 2;
            int j = (this.height - this.imageHeight) / 2;
            int k = j + 16;
            int limit = Math.min(newPetList.size(), 7);
            this.petButtons = new PetButton[limit];
            for (int index = 0; index < limit; ++index) {
                this.petButtons[index] = (PetButton)this.addRenderableWidget((GuiEventListener)new PetButton(i + 5, k, index, newPetList.get(index), this::petButtonClick));
                k += 20;
            }
        }
        this.isLoading = false;
    }

    private void petButtonClick(Button button) {
        if (button instanceof PetButton) {
            PetButton petButton = (PetButton)button;
            this.petItem = petButton.getIndex() + this.scrollOff;
            if (this.petItem != -1) {
                this.selectButton.active = false;
                this.selectButton.visible = false;
                this.reviveButton.visible = true;
                this.reviveButton.active = !PickablePets.CACHE.isPetAlive(petButton.getPetID()) && ((ReviveAltarContainer)this.menu).hasReviveCurrency() && Minecraft.getInstance().player != null;
            }
        }
    }

    private void reviveButtonClick() {
        if (this.petItem == -1 || !((ReviveAltarContainer)this.menu).hasReviveCurrency()) {
            return;
        }
        RevivePacket.Client.sendToServer(this.petIDS.get(this.petItem), ((ReviveAltarContainer)this.menu).getBlockPosition());
    }

    public void updateButtons(boolean fullRefresh) {
        boolean alive;
        UUID id;
        LivingEntity pet;
        if (fullRefresh) {
            AltarRequestPacket.Client.sendToServer();
        }
        this.reviveButton.active = this.petItem != -1 && ((ReviveAltarContainer)this.menu).hasReviveCurrency() ? ((pet = PickablePets.CACHE.getPet(id = this.petIDS.get(this.petItem))) != null && Minecraft.getInstance().player != null ? !(alive = PickablePets.CACHE.isPetAlive(id)) : false) : false;
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        LivingEntity pet;
        this.renderBackground(guiGraphics, i, j, f);
        super.render(guiGraphics, i, j, f);
        if (this.petIDS != null && !this.petIDS.isEmpty() && this.petButtons != null) {
            int k = (this.width - this.imageWidth) / 2;
            int l = (this.height - this.imageHeight) / 2;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            this.renderScroller(guiGraphics, k, l);
            int start = this.scrollOff;
            for (PetButton button : this.petButtons) {
                button.updateButton(this.petIDS.get(start), start);
                button.visible = button.getIndex() < this.petIDS.size();
                ++start;
            }
            RenderSystem.enableDepthTest();
        }
        if (this.petItem != -1 && (pet = PickablePets.CACHE.getRender(this.petIDS.get(this.petItem))) != null) {
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(this.leftPos + 113), (int)(this.topPos + 17), (int)(this.leftPos + 162), (int)(this.topPos + 66), (int)30, (float)0.0625f, (float)i, (float)j, (LivingEntity)pet);
        }
        this.renderTooltip(guiGraphics, i, j);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        LivingEntity pet;
        super.renderLabels(guiGraphics, i, j);
        if (this.isLoading) {
            MutableComponent text = Component.translatable((String)"gui.pickablepets.loading");
            FormattedCharSequence formattedCharSequence = text.getVisualOrderText();
            guiGraphics.drawString(this.font, (Component)text, 220 - this.font.width(formattedCharSequence) / 2, 25, 0xFFFFFF, false);
        } else if (this.petIDS == null || this.petIDS.isEmpty()) {
            MutableComponent text = Component.translatable((String)"gui.pickablepets.nopets");
            FormattedCharSequence formattedCharSequence = text.getVisualOrderText();
            guiGraphics.drawString(this.font, (Component)text, 220 - this.font.width(formattedCharSequence) / 2, 25, 0x404040, false);
        } else if (this.petItem != -1 && (pet = PickablePets.CACHE.getPet(this.petIDS.get(this.petItem))) != null) {
            int textY = 6;
            MutableComponent text = Component.translatable((String)"gui.pickablepets.dim").withStyle(ChatFormatting.UNDERLINE);
            FormattedCharSequence formattedCharSequence = text.getVisualOrderText();
            guiGraphics.drawString(this.font, (Component)text, 220 - this.font.width(formattedCharSequence) / 2, textY, 0xFFFFFF, false);
            text = Component.translatable((String)pet.level().dimension().location().toString());
            formattedCharSequence = text.getVisualOrderText();
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, (Component)text, 220 - this.font.width(formattedCharSequence) / 2, textY += 9 + 2, 15767114, false);
            text = Component.translatable((String)"gui.pickablepets.pos").withStyle(ChatFormatting.UNDERLINE);
            formattedCharSequence = text.getVisualOrderText();
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, (Component)text, 220 - this.font.width(formattedCharSequence) / 2, textY += 9 + 3, 0xFFFFFF, false);
            text = PickablePets.CACHE.isInItem(this.petIDS.get(this.petItem)) ? Component.translatable((String)"gui.pickablepets.pos.item") : Component.literal((String)pet.blockPosition().toShortString());
            formattedCharSequence = text.getVisualOrderText();
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, (Component)text, 220 - this.font.width(formattedCharSequence) / 2, textY += 9 + 2, 15767114, false);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.width - this.imageWidth) / 2;
        int l = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, k, l, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 256);
    }

    private void renderScroller(GuiGraphics guiGraphics, int i, int j) {
        int k = this.petIDS.size() + 1 - 7;
        if (k > 1) {
            int l = 139 - (27 + (k - 1) * 139 / k);
            int m = 1 + l / k + 139 / k;
            int o = Math.min(123, this.scrollOff * m);
            if (this.scrollOff == k - 1) {
                o = 123;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.blit(TEXTURE, i + 94, j + 17 + o, 288.0f, 0.0f, 6, 16, 512, 256);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.blit(TEXTURE, i + 94, j + 17, 294.0f, 0.0f, 6, 16, 512, 256);
        }
    }

    private boolean canScroll(int i) {
        return i > 7;
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.petIDS == null || this.petIDS.isEmpty()) {
            return super.mouseScrolled(d, e, f, g);
        }
        int i = this.petIDS.size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.scrollOff = Mth.clamp((int)((int)((double)this.scrollOff - g)), (int)0, (int)j);
        }
        return true;
    }

    public boolean mouseDragged(double d, double e, int i, double f, double g) {
        if (this.petIDS == null || this.petIDS.isEmpty()) {
            return super.mouseDragged(d, e, i, f, g);
        }
        int j = this.petIDS.size();
        if (this.isDragging) {
            int k = this.topPos + 18;
            int l = k + 139;
            int m = j - 7;
            float h = ((float)e - (float)k - 13.5f) / ((float)(l - k) - 27.0f);
            h = h * (float)m + 0.5f;
            this.scrollOff = Mth.clamp((int)((int)h), (int)0, (int)m);
            return true;
        }
        return super.mouseDragged(d, e, i, f, g);
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (this.petIDS == null || this.petIDS.isEmpty()) {
            return super.mouseClicked(d, e, i);
        }
        this.isDragging = false;
        int j = (this.width - this.imageWidth) / 2;
        int k = (this.height - this.imageHeight) / 2;
        if (this.canScroll(this.petIDS.size()) && d > (double)(j + 94) && d < (double)(j + 94 + 6) && e > (double)(k + 18) && e <= (double)(k + 18 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.mouseClicked(d, e, i);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

