/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.data;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.shiftthedev.pickablepets.PPRegistry;
import com.shiftthedev.pickablepets.PickablePets;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class Helper {
    public static boolean Pickup(LivingEntity livingEntity, LivingEntity playerEntity) {
        if (!(playerEntity instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer player = (ServerPlayer)playerEntity;
        if (!(livingEntity instanceof OwnableEntity)) {
            return false;
        }
        OwnableEntity ownableEntity = (OwnableEntity)livingEntity;
        if (ownableEntity.getOwner() == null) {
            return false;
        }
        if (!ownableEntity.getOwnerUUID().equals(player.getUUID())) {
            return false;
        }
        if (!Helper.isPickable(livingEntity, (Player)player)) {
            return false;
        }
        player.level().getServer().execute(() -> {
            ItemStack stack = PickablePets.CACHE.createItemStack(livingEntity, new ItemStack((ItemLike)PPRegistry.PET_ITEM.get()));
            if (!player.addItem(stack)) {
                player.displayClientMessage((Component)Component.translatable((String)"message.pickablepets.full_inventory"), true);
            } else {
                PickablePets.CACHE.cache(livingEntity);
                PickablePets.CACHE.setPetItem(livingEntity.getUUID(), true);
                PickablePets.CACHE.setUpdated(livingEntity.getUUID());
                player.giveExperienceLevels(-PickablePets.CONFIG.PickupCost);
                livingEntity.remove(Entity.RemovalReason.DISCARDED);
                player.playSound(SoundEvents.VILLAGER_YES, 1.0f, player.getVoicePitch());
            }
        });
        return true;
    }

    private static boolean isPickable(LivingEntity livingEntity, Player playerEntity) {
        if (PickablePets.CONFIG.MaxPetsInInventory > 0 && Helper.countSlotMatchingItem(playerEntity) >= PickablePets.CONFIG.MaxPetsInInventory) {
            playerEntity.displayClientMessage((Component)Component.translatable((String)"message.pickablepets.inventory_full"), true);
            return false;
        }
        if (!livingEntity.isAlive()) {
            playerEntity.displayClientMessage((Component)Component.translatable((String)"message.pickablepets.dead"), true);
            return false;
        }
        if (livingEntity.isPassenger()) {
            playerEntity.displayClientMessage((Component)Component.translatable((String)"message.pickablepets.passenger", (Object[])new Object[]{livingEntity.getVehicle().getDisplayName()}), true);
            return false;
        }
        if (!livingEntity.getPassengers().isEmpty()) {
            playerEntity.displayClientMessage((Component)Component.translatable((String)"message.pickablepets.rider"), true);
            return false;
        }
        if (livingEntity.isBaby() && PickablePets.CONFIG.OnlyAdults) {
            playerEntity.displayClientMessage((Component)Component.translatable((String)"message.pickablepets.baby"), true);
            return false;
        }
        if (livingEntity.isSleeping()) {
            playerEntity.displayClientMessage((Component)Component.translatable((String)"message.pickablepets.sleep"), true);
            return false;
        }
        double distance = playerEntity.distanceTo((Entity)livingEntity);
        if (distance > (double)PickablePets.CONFIG.PickupDistance) {
            playerEntity.displayClientMessage((Component)Component.translatable((String)"message.pickablepets.far"), true);
            return false;
        }
        if (!playerEntity.isCreative() && playerEntity.experienceLevel < PickablePets.CONFIG.PickupCost) {
            playerEntity.displayClientMessage((Component)Component.translatable((String)"message.pickablepets.noxp"), true);
            return false;
        }
        return true;
    }

    private static int countSlotMatchingItem(Player player) {
        Inventory inventory = player.getInventory();
        int count = 0;
        for (int i = 0; i < inventory.items.size(); ++i) {
            if (((ItemStack)inventory.items.get(i)).isEmpty() || !((Item)PPRegistry.PET_ITEM.get()).equals(((ItemStack)inventory.items.get(i)).getItem())) continue;
            ++count;
        }
        return count;
    }

    public static void renderPet(LivingEntity entity, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, EntityRenderDispatcher entityRenderer, float rotation, float scale) {
        if (entity != null) {
            poseStack.pushPose();
            float s = scale / entity.getBbHeight();
            poseStack.translate(0.5, 0.125, 0.5);
            poseStack.mulPose(Axis.YN.rotationDegrees(rotation));
            if (entity.deathTime == 20) {
                poseStack.mulPose(Axis.ZN.rotationDegrees(-90.0f));
            }
            poseStack.pushPose();
            poseStack.scale(s, s, s);
            entityRenderer.setRenderShadow(false);
            entityRenderer.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, i);
            entityRenderer.setRenderShadow(true);
            poseStack.popPose();
            poseStack.popPose();
        }
    }
}

