/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.data;

import com.mojang.serialization.Codec;
import com.shiftthedev.alexandria.Alexandria;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class PetDataComponent {
    public static final Codec<PetDataComponent> CODEC = CompoundTag.CODEC.xmap(PetDataComponent::fromTag, dataComponent -> dataComponent.tag);
    public static final StreamCodec<RegistryFriendlyByteBuf, PetDataComponent> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, PetDataComponent>(){

        public PetDataComponent decode(RegistryFriendlyByteBuf buffer) {
            return new PetDataComponent(buffer.readNbt(), buffer.readInt());
        }

        public void encode(RegistryFriendlyByteBuf buffer, PetDataComponent data) {
            buffer.writeNbt((Tag)data.tag);
            buffer.writeInt(data.version);
        }
    };
    public final CompoundTag tag;
    public final int version;

    public PetDataComponent(CompoundTag tag, int version) {
        this.tag = tag;
        this.version = version;
    }

    public static PetDataComponent fromTag(CompoundTag tag) {
        if (!tag.contains("VERSION")) {
            return new PetDataComponent(tag, Alexandria.VERSION);
        }
        tag.remove("VERSION");
        return new PetDataComponent(tag, tag.getInt("VERSION"));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PetDataComponent other = (PetDataComponent)obj;
        return Objects.equals(this.tag, other.tag) && this.version == other.version;
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.version);
    }
}

