/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.data;

import com.shiftthedev.alexandria.data.EntityInfo;
import com.shiftthedev.pickablepets.data.ItemTagFixer;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.level.Level;

public class PetInfo
extends EntityInfo<LivingEntity> {
    private boolean inItem;
    private boolean isAlive;
    private boolean wasRevived;
    private String ownerName;
    private AttributeMap attributeMap;
    private boolean updated;

    public PetInfo(LivingEntity entity) {
        super(entity);
        if (entity != null) {
            this.inItem = false;
            this.isAlive = true;
            this.wasRevived = false;
            this.trySetOwner();
            this.attributeMap = entity.getAttributes();
        }
    }

    public void setInItem(boolean flag) {
        this.inItem = flag;
    }

    public boolean isInItem() {
        return this.inItem;
    }

    public ListTag getAttributes() {
        if (this.attributeMap != null) {
            return this.attributeMap.save();
        }
        return new ListTag();
    }

    public String getOwner() {
        if (this.ownerName == null || this.ownerName.isEmpty()) {
            this.trySetOwner();
        }
        return this.ownerName;
    }

    private void trySetOwner() {
        Component name;
        if (this.entity == null) {
            this.ownerName = "";
            return;
        }
        LivingEntity ownerEntity = ((OwnableEntity)this.entity).getOwner();
        this.ownerName = ownerEntity != null ? ((name = ownerEntity.getDisplayName()) != null ? name.getString() : "") : "";
    }

    public void updateAttributes(LivingEntity entity) {
        this.attributeMap = entity.getAttributes();
    }

    public void markDead() {
        this.isAlive = false;
    }

    public void revive() {
        this.entity.fallDistance = 0.0f;
        this.entity.setSpeed(0.0f);
        this.isAlive = true;
        this.wasRevived = true;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated() {
        this.updated = true;
    }

    public boolean wasRevived() {
        return this.wasRevived;
    }

    public CompoundTag save(CompoundTag tag) {
        super.save(tag);
        if (this.entity == null) {
            return tag;
        }
        tag.putBoolean("pp_item", this.inItem);
        tag.putBoolean("pp_alive", this.isAlive);
        tag.putBoolean("pp_revived", this.wasRevived);
        tag.putString("pp_owner", this.ownerName);
        if (this.attributeMap != null) {
            tag.put("pp_attr", (Tag)this.attributeMap.save());
        }
        tag.putBoolean("pp_updated", this.updated);
        return tag;
    }

    public void load(UUID entityID, CompoundTag tag, Level level) {
        if (tag.contains("pp_type")) {
            tag.putString("entity_type", tag.getString("pp_type"));
            tag.remove("pp_type");
        }
        tag = ItemTagFixer.fixItemTag(tag);
        super.load(entityID, tag, level);
        this.inItem = tag.contains("pp_item") && tag.getBoolean("pp_item");
        this.isAlive = tag.contains("pp_alive") && tag.getBoolean("pp_alive");
        this.wasRevived = tag.contains("pp_revived") && tag.getBoolean("pp_revived");
        String string = this.ownerName = tag.contains("pp_owner") ? tag.getString("pp_owner") : "";
        if (tag.contains("pp_attr")) {
            this.attributeMap = this.entity.getAttributes();
            this.attributeMap.load(tag.getList("pp_attr", 10));
        }
        if (tag.contains("pp_updated")) {
            this.updated = tag.getBoolean("pp_updated");
        }
        level.getProfiler().pop();
    }
}

