/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.data;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PlayerPets {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(20);

    public static CompletableFuture<Void> addPetAsync(Path path, String petID) {
        return PlayerPets.loadPetAsync(path).thenCompose(pets -> {
            if (!pets.contains(petID)) {
                pets.add(petID);
            }
            return PlayerPets.savePetAsync(path, pets);
        });
    }

    public static CompletableFuture<Void> syncPetsAsync(Path path, List<UUID> serverPets) {
        return PlayerPets.loadPetAsync(path).thenCompose(clientPets -> {
            serverPets.forEach(serverPet -> {
                if (!clientPets.contains(serverPet.toString())) {
                    clientPets.add(serverPet.toString());
                }
            });
            return PlayerPets.savePetAsync(path, clientPets);
        });
    }

    public static CompletableFuture<Void> replacePetAsync(Path path, String oldPet, String newPet) {
        return PlayerPets.loadPetAsync(path).thenCompose(pets -> {
            if (pets.contains(oldPet)) {
                pets.remove(oldPet);
            }
            pets.add(newPet);
            return PlayerPets.savePetAsync(path, pets);
        });
    }

    public static CompletableFuture<Void> removePetAsync(Path path, String pet) {
        return PlayerPets.loadPetAsync(path).thenCompose(pets -> {
            if (pets.contains(pet)) {
                pets.remove(pet);
            }
            return PlayerPets.savePetAsync(path, pets);
        });
    }

    public static CompletableFuture<Void> removeBrokenPetsAsync(Path path, List<String> broken) {
        return PlayerPets.loadPetAsync(path).thenCompose(pets -> {
            pets.removeAll(broken);
            return PlayerPets.savePetAsync(path, pets);
        });
    }

    private static CompletableFuture<Void> savePetAsync(Path file, List<String> pets) {
        return CompletableFuture.runAsync(() -> {
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                if (file.toFile().exists()) {
                    Files.delete(file);
                }
                Files.write(file, (Iterable<? extends CharSequence>)pets, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, EXECUTOR_SERVICE);
    }

    public static void saveOldPet(String petId, Path path) {
        try {
            List<String> pets;
            if (Files.exists(path, new LinkOption[0])) {
                pets = Files.readAllLines(path);
            } else {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                pets = new ArrayList<String>();
            }
            if (pets.contains(petId)) {
                return;
            }
            pets.add(petId);
            Files.write(path, pets, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static CompletableFuture<List<String>> loadPetAsync(Path path) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    return Files.readAllLines(path);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return new ArrayList();
        }, EXECUTOR_SERVICE);
    }
}

