/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.network;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.data.PlayerPets;
import com.shiftthedev.pickablepets.network.AltarUpdatePacket;
import dev.architectury.networking.NetworkManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AltarRequestPacket {
    private static final ResourceLocation PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"pickablepets", (String)"altar_request");
    private static final CustomPacketPayload.Type<AltarRequestPayload> TYPE = new CustomPacketPayload.Type(PACKET_ID);
    private static final StreamCodec<FriendlyByteBuf, AltarRequestPayload> CODEC = StreamCodec.ofMember(AltarRequestPayload::write, AltarRequestPayload::read);

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), TYPE, CODEC, AltarRequestPacket::receive);
    }

    public static void receive(AltarRequestPayload payload, NetworkManager.PacketContext context) {
        if (context.getPlayer().isLocalPlayer()) {
            return;
        }
        UUID playerID = payload.uuid();
        Path path = context.getPlayer().getServer().getWorldPath(new LevelResource("data/pets"));
        path = path.resolve(playerID.toString() + ".pets");
        ArrayList<String> broken = new ArrayList<String>();
        PlayerPets.loadPetAsync(path).thenCompose(list -> {
            ArrayList<String> fixed = new ArrayList<String>();
            list.forEach(uuid -> {
                if (PickablePets.CACHE.isValidPet(UUID.fromString(uuid))) {
                    fixed.add((String)uuid);
                } else {
                    broken.add((String)uuid);
                }
            });
            AltarUpdatePacket.sendToPlayer((ServerPlayer)context.getPlayer(), fixed);
            return null;
        });
        PlayerPets.removeBrokenPetsAsync(path, broken);
    }

    private record AltarRequestPayload(UUID uuid) implements CustomPacketPayload
    {
        public void write(FriendlyByteBuf buf) {
            buf.writeUUID(this.uuid);
        }

        public static AltarRequestPayload read(FriendlyByteBuf buf) {
            return new AltarRequestPayload(buf.readUUID());
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        public static void sendToServer() {
            NetworkManager.sendToServer((CustomPacketPayload)new AltarRequestPayload(Minecraft.getInstance().player.getUUID()));
        }
    }
}

