/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ChatPacket {
    private static final ResourceLocation PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"pickablepets", (String)"chat");
    private static final CustomPacketPayload.Type<ChatPayload> TYPE = new CustomPacketPayload.Type(PACKET_ID);
    private static final StreamCodec<FriendlyByteBuf, ChatPayload> CODEC = StreamCodec.ofMember(ChatPayload::write, ChatPayload::read);

    public static void register() {
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType(TYPE, CODEC);
        } else {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), TYPE, CODEC, ChatPacket::receive);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void receive(ChatPayload payload, NetworkManager.PacketContext context) {
        context.getPlayer().displayClientMessage((Component)Component.translatable((String)payload.msgID), true);
    }

    public static void sendToPlayer(ServerPlayer player, String msgID) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ChatPayload(msgID));
    }

    private record ChatPayload(String msgID) implements CustomPacketPayload
    {
        public void write(FriendlyByteBuf buf) {
            buf.writeUtf("message.pickablepets." + this.msgID);
        }

        public static ChatPayload read(FriendlyByteBuf buf) {
            return new ChatPayload(buf.readUtf());
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

