/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.blocks.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.shiftthedev.pickablepets.PickablePetsClient;
import com.shiftthedev.pickablepets.blocks.blockentities.ReviveAltarBlockEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class ReviveAltarRenderer
implements BlockEntityRenderer<ReviveAltarBlockEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/end_crystal/end_crystal.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)TEXTURE);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private final ModelPart glass;
    private final ModelPart cube;

    public ReviveAltarRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(PickablePetsClient.ALTAR_BALL);
        this.glass = modelPart.m_171324_("glass");
        this.cube = modelPart.m_171324_("cube");
    }

    public static LayerDefinition createBallLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("glass", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        partDefinition.m_171599_("cube", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void render(ReviveAltarBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        poseStack.m_85836_();
        float h = ReviveAltarRenderer.getY(blockEntity, f);
        float j = ((float)blockEntity.time + f) * 3.0f;
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RENDER_TYPE);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        int k = OverlayTexture.f_118083_;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(j));
        poseStack.m_85837_(0.0, (double)(1.5f + h / 2.0f), 0.0);
        poseStack.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        this.glass.m_104301_(poseStack, vertexConsumer, light, k);
        poseStack.m_85841_(0.875f, 0.875f, 0.875f);
        poseStack.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(j));
        this.glass.m_104301_(poseStack, vertexConsumer, light, k);
        poseStack.m_85841_(0.875f, 0.875f, 0.875f);
        poseStack.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(j));
        this.cube.m_104301_(poseStack, vertexConsumer, light, k);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    public static float getY(ReviveAltarBlockEntity blockEntity, float f) {
        float g = (float)blockEntity.time + f;
        float h = Mth.m_14031_((float)(g * 0.2f)) / 2.0f + 0.5f;
        h = (h * h + h) * 0.4f;
        return h - 1.4f;
    }
}

