/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.shiftthedev.pickablepets.utils.CachedPets;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PetButton
extends Button {
    private static final ResourceLocation TEXTURE = new ResourceLocation("pickablepets", "textures/gui/altar.png");
    private static final MutableComponent ALIVE = Component.m_237115_((String)"gui.pickablepets.alive");
    private static final MutableComponent DEAD = Component.m_237115_((String)"gui.pickablepets.dead");
    private int index;
    private UUID petID;

    public PetButton(int i, int j, int index, UUID petID, Button.OnPress onPress) {
        super(i, j, 88, 20, (Component)Component.m_237119_(), onPress, f_252438_);
        this.index = index;
        this.petID = petID;
        this.f_93624_ = false;
    }

    public int getIndex() {
        return this.index;
    }

    public UUID getPetID() {
        return this.petID;
    }

    public void updateButton(UUID petID, int index) {
        this.petID = petID;
    }

    protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        int offset = 0;
        if (this.m_274382_()) {
            offset = this.m_93696_() ? 40 : 20;
        } else if (this.m_93696_()) {
            offset = 60;
        }
        guiGraphics.m_280411_(TEXTURE, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 80.0f, (float)(176 + offset), this.f_93618_, this.f_93619_, 512, 256);
        guiGraphics.m_280430_(font, CachedPets.getPetName(this.petID), this.m_252754_() + 3, this.m_252907_() + 3, 0xFFFFFF);
        boolean isAlive = CachedPets.isPetAlive(this.petID);
        MutableComponent text = isAlive ? ALIVE : DEAD;
        FormattedCharSequence formattedCharSequence = text.m_7532_();
        int n = this.m_252754_() + this.f_93618_ - font.m_92724_(formattedCharSequence) - 3;
        int n2 = this.m_252907_();
        Objects.requireNonNull(font);
        guiGraphics.m_280430_(font, (Component)text, n, n2 + 9, isAlive ? 0x78FF78 : 0xFF7878);
    }
}

