/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.client.ItemRendererRegistry;
import com.shiftthedev.pickablepets.compat.AlexsCavesHelper;
import com.shiftthedev.pickablepets.compat.DawnEraHelper;
import com.shiftthedev.pickablepets.utils.CachedPets;
import com.shiftthedev.pickablepets.utils.Helper;
import dev.architectury.platform.Platform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class PetItemRenderer
implements ItemRendererRegistry.DynamicItemRenderer {
    private EntityRenderDispatcher entityRenderer;

    @Override
    public void render(ItemStack itemStack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        LivingEntity pet;
        if (this.entityRenderer == null) {
            this.entityRenderer = Minecraft.m_91087_().m_91290_();
        }
        if ((pet = CachedPets.getItemRender(itemStack)) == null) {
            return;
        }
        if (Platform.isForge()) {
            if (PickablePets.FoundAlexCaves && pet.m_6095_().arch$registryName().toString().contains("alexscaves")) {
                AlexsCavesHelper.renderCavePet(pet, poseStack, multiBufferSource, light, this.entityRenderer, 0.0f, 0.85f);
                return;
            }
            if (PickablePets.FoundDawnEra && pet.m_6095_().arch$registryName().toString().contains("dawnera")) {
                DawnEraHelper.render(pet, this.entityRenderer, poseStack, multiBufferSource, light, 0.0f, 0.85f);
                return;
            }
        }
        Helper.renderPet(pet, poseStack, multiBufferSource, light, this.entityRenderer, 0.0f, 0.85f);
    }
}

