/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.mixins;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.utils.CachedPets;
import com.shiftthedev.pickablepets.utils.PlayerPets;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TamableAnimal.class})
public abstract class TamableAnimalMixin
extends Animal
implements OwnableEntity {
    @Shadow
    @Nullable
    public abstract UUID m_21805_();

    protected TamableAnimalMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tame"}, at={@At(value="INVOKE", target="Lnet/minecraft/advancements/critereon/TameAnimalTrigger;trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/entity/animal/Animal;)V", shift=At.Shift.AFTER)})
    private void tame_pets(Player player, CallbackInfo ci) {
        String entityKey;
        if (!(this.m_9236_().f_46443_ || PickablePets.CONFIG.BlacklistedPets.contains(entityKey = EntityType.m_20613_((EntityType)this.m_6095_()).toString()) || PickablePets.CONFIG.BlacklistedMods.contains(entityKey.split(":")[0]))) {
            UUID owner = this.m_21805_();
            if (owner == null) {
                return;
            }
            Path path = ((ServerLevel)this.m_9236_()).m_7654_().m_129843_(new LevelResource("data/pets"));
            path = path.resolve(owner.toString() + ".pets");
            PlayerPets.addPetAsync(path, this.m_20148_());
            CachedPets.addPet((LivingEntity)((TamableAnimal)this));
            CachedPets.setUpdated(this.m_20148_());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readAdditionalSaveData_pets(CompoundTag compoundTag, CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            if (!compoundTag.m_128441_("dog_reviving")) {
                String entityKey = EntityType.m_20613_((EntityType)this.m_6095_()).toString();
                if (!PickablePets.CONFIG.BlacklistedPets.contains(entityKey) && !PickablePets.CONFIG.BlacklistedMods.contains(entityKey.split(":")[0]) && !CachedPets.isPetUpdated(this.m_20148_()) && compoundTag.m_128403_("Owner")) {
                    PlayerPets.saveOldPet(this.m_20148_().toString(), compoundTag.m_128342_("Owner").toString(), (ServerLevel)this.m_9236_());
                    CachedPets.addPet((LivingEntity)((TamableAnimal)this));
                    CachedPets.setUpdated(this.m_20148_());
                }
            } else {
                compoundTag.m_128473_("dog_reviving");
            }
        }
    }
}

