/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.network;

import com.shiftthedev.pickablepets.client.gui.ReviveAltarScreen;
import com.shiftthedev.pickablepets.utils.CachedPets;
import com.shiftthedev.pickablepets.utils.PlayerPets;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AltarPacket {
    private static final ResourceLocation PACKET_ID = new ResourceLocation("pickablepets", "altar");

    public static class Server {
        public static void register() {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)PACKET_ID, Server::receive);
        }

        public static void sendToPlayer(ServerPlayer player, List<String> petsIDS) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.writeInt(petsIDS.size());
            petsIDS.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)PACKET_ID, (FriendlyByteBuf)buffer);
        }

        public static void receive(FriendlyByteBuf buffer, NetworkManager.PacketContext context) {
            if (context.getPlayer().m_7578_()) {
                return;
            }
            UUID playerID = buffer.m_130259_();
            Path path = context.getPlayer().m_20194_().m_129843_(new LevelResource("data/pets"));
            path = path.resolve(playerID.toString() + ".pets");
            ArrayList<String> broken = new ArrayList<String>();
            PlayerPets.loadPetAsync(path).thenCompose(list -> {
                ArrayList<String> fixed = new ArrayList<String>();
                list.forEach(uuid -> {
                    if (CachedPets.isValidPet(uuid)) {
                        fixed.add((String)uuid);
                    } else {
                        broken.add((String)uuid);
                    }
                });
                Server.sendToPlayer((ServerPlayer)context.getPlayer(), fixed);
                return null;
            });
            PlayerPets.removeBrokenPetsAsync(path, broken);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        public static void register() {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)PACKET_ID, Client::receive);
        }

        public static void sendToServer() {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.m_130077_(Minecraft.m_91087_().f_91074_.m_20148_());
            NetworkManager.sendToServer((ResourceLocation)PACKET_ID, (FriendlyByteBuf)buffer);
        }

        public static void receive(FriendlyByteBuf buffer, NetworkManager.PacketContext context) {
            if (!context.getPlayer().m_7578_()) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            Screen screen = mc.f_91080_;
            if (!(screen instanceof ReviveAltarScreen)) {
                return;
            }
            ReviveAltarScreen altarScreen = (ReviveAltarScreen)screen;
            ArrayList<UUID> pets = new ArrayList<UUID>();
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                UUID uuid = UUID.fromString(buffer.m_130277_());
                CachedPets.getRender(uuid);
                pets.add(uuid);
            }
            altarScreen.populatePetList(pets);
        }
    }
}

