/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.network;

import com.shiftthedev.pickablepets.utils.CachedPets;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class ManagePetsPacket {
    private static final ResourceLocation PACKET_ID = new ResourceLocation("pickablepets", "manager");

    public static void sendToPlayer(UUID petUUID, CompoundTag petTag, ServerPlayer player) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130077_(petUUID);
        buffer.m_130079_(petTag);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)PACKET_ID, (FriendlyByteBuf)buffer);
    }

    public static void sendToServer(UUID uuid) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130077_(uuid);
        NetworkManager.sendToServer((ResourceLocation)PACKET_ID, (FriendlyByteBuf)buffer);
    }

    public static class Server {
        public static void register() {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)PACKET_ID, Server::receive);
        }

        public static void receive(FriendlyByteBuf buffer, NetworkManager.PacketContext context) {
            if (context.getPlayer().m_7578_()) {
                return;
            }
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            UUID uuid = buffer.m_130259_();
            CachedPets.sendPetsToPlayer(player, uuid);
        }
    }

    public static class Client {
        public static void register() {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)PACKET_ID, Client::receive);
        }

        public static void receive(FriendlyByteBuf buffer, NetworkManager.PacketContext context) {
            if (!context.getPlayer().m_7578_()) {
                return;
            }
            CachedPets.getPetFromServer(buffer.m_130259_(), buffer.m_130260_(), (Level)Minecraft.m_91087_().f_91073_);
        }
    }
}

