/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.network;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.blocks.blockentities.ReviveAltarBlockEntity;
import com.shiftthedev.pickablepets.compat.DoggyHelper;
import com.shiftthedev.pickablepets.mixins.EntityAccessor;
import com.shiftthedev.pickablepets.network.ChatPacket;
import com.shiftthedev.pickablepets.utils.CachedPets;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RevivePacket {
    private static final ResourceLocation PACKET_ID = new ResourceLocation("pickablepets", "revive");

    public static class Server {
        public static void register() {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)PACKET_ID, Server::receive);
        }

        public static void receive(FriendlyByteBuf buffer, NetworkManager.PacketContext context) {
            if (context.getPlayer().m_7578_()) {
                return;
            }
            UUID petID = buffer.m_130259_();
            BlockPos revivePos = buffer.m_130135_();
            Level level = context.getPlayer().m_9236_();
            LivingEntity cachedPet = CachedPets.getPet(petID);
            if (cachedPet == null || CachedPets.isPetAlive(petID)) {
                return;
            }
            BlockPos spanwPos = null;
            for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                for (int zOffeset = -2; zOffeset <= 2; ++zOffeset) {
                    if (!level.m_45772_(cachedPet.m_6095_().m_20585_((double)(revivePos.m_123341_() + xOffset), (double)revivePos.m_123342_(), (double)(revivePos.m_123343_() + zOffeset)))) continue;
                    spanwPos = new BlockPos(revivePos.m_123341_() + xOffset, revivePos.m_123342_(), revivePos.m_123343_() + zOffeset);
                    break;
                }
                if (spanwPos != null) break;
            }
            if (spanwPos == null) {
                ChatPacket.sendToPlayer((ServerPlayer)context.getPlayer(), "spawn");
                return;
            }
            BlockPos finalSpanwPos = spanwPos;
            level.m_7654_().execute(() -> {
                BlockEntity be;
                if (PickablePets.FoundDoggy && DoggyHelper.isFromMod(cachedPet)) {
                    LivingEntity pet = DoggyHelper.reviveDog(cachedPet, petID, context.getPlayer(), (ServerLevel)level, finalSpanwPos);
                    if (pet == null) {
                        return;
                    }
                } else {
                    LivingEntity pet = (LivingEntity)cachedPet.m_6095_().m_20615_(level);
                    if (pet == null) {
                        return;
                    }
                    ((EntityAccessor)cachedPet).setRemovalReason(null);
                    ((EntityAccessor)cachedPet).setLevel(level);
                    CompoundTag tag = cachedPet.m_20240_(new CompoundTag());
                    tag.m_128379_("Sitting", false);
                    tag.m_128376_("DeathTime", (short)0);
                    cachedPet.m_20258_(tag);
                    pet.m_20361_((Entity)cachedPet);
                    pet.m_21204_().m_22168_(CachedPets.getPetAttributes(cachedPet.m_20148_()));
                    pet.m_146884_(Vec3.m_82512_((Vec3i)finalSpanwPos));
                    pet.m_21153_(cachedPet.m_21233_());
                    if (!level.m_7967_((Entity)pet)) {
                        return;
                    }
                    CachedPets.revivePet(petID);
                    CachedPets.addPet(pet);
                }
                if ((be = level.m_46745_(revivePos).m_5685_(revivePos, LevelChunk.EntityCreationType.IMMEDIATE)) instanceof ReviveAltarBlockEntity) {
                    ReviveAltarBlockEntity rbe = (ReviveAltarBlockEntity)be;
                    ItemStack stack = rbe.m_8020_(0).m_41777_();
                    stack.m_41774_(1);
                    rbe.m_6836_(0, stack);
                }
                CachedPets.sendPetsToPlayers(level, petID);
                level.m_46473_().m_7238_();
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        public static void sendToServer(UUID petID, BlockPos revivePos) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.m_130077_(petID);
            buffer.m_130064_(revivePos);
            NetworkManager.sendToServer((ResourceLocation)PACKET_ID, (FriendlyByteBuf)buffer);
        }
    }
}

